/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.support;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.cluster.Cluster;
import com.alibaba.dubbo.rpc.cluster.Directory;
import com.alibaba.dubbo.rpc.cluster.LoadBalance;
import com.alibaba.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import kd.bos.exception.DubboErrorCode;
import kd.bos.util.resource.Resources;

public class AvailableCluster
implements Cluster {
    public static final String NAME = "available";

    public <T> Invoker<T> join(Directory<T> directory) throws RpcException {
        return new AbstractClusterInvoker<T>(directory){

            @Override
            public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
                for (Invoker invoker : invokers) {
                    if (!invoker.isAvailable()) continue;
                    return invoker.invoke(invocation);
                }
                LockSupport.parkNanos(100000000L);
                for (Invoker invoker : invokers) {
                    if (!invoker.isAvailable()) continue;
                    return invoker.invoke(invocation);
                }
                ArrayList<String> mserviceInstanceIdList = new ArrayList<String>(invokers.size());
                for (Invoker invoker : invokers) {
                    mserviceInstanceIdList.add(invoker.getUrl().getParameter("instance.id"));
                }
                String string = Resources.getString((String)"\u670d\u52a1\u4e0d\u53ef\u7528, invoker\u5217\u8868\u4e3a:", (String)"AvailableCluster_0", (String)"bos-mservice-dubbox", (Object[])new Object[0]) + mserviceInstanceIdList;
                throw new RpcException(DubboErrorCode.consumerProviderNetworkClose.getCode(), string);
            }
        };
    }
}

