/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.cluster.support;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.Version;
import com.alibaba.dubbo.common.logger.Logger;
import com.alibaba.dubbo.common.logger.LoggerFactory;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcStatus;
import com.alibaba.dubbo.rpc.cluster.Directory;
import com.alibaba.dubbo.rpc.cluster.LoadBalance;
import com.alibaba.dubbo.rpc.cluster.support.AbstractClusterInvoker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.mservice.rpc.handshake.entity.HandShakeException;
import kd.bos.thread.ThreadTruck;

public class FailoverClusterInvoker<T>
extends AbstractClusterInvoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(FailoverClusterInvoker.class);
    public static final String DUBBOHANDSHAKE_KEY = "dubbo.Handshake";

    public FailoverClusterInvoker(Directory<T> directory) {
        super(directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        List<Invoker<T>> copyinvokers = invokers;
        this.checkInvokers(copyinvokers, invocation);
        int len = this.getUrl().getMethodParameter(invocation.getMethodName(), "retries", 2) + 1;
        if (len <= 0) {
            len = 1;
        }
        RpcException le = null;
        ArrayList invoked = new ArrayList(copyinvokers.size());
        HashSet<String> providers = new HashSet<String>(len);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                this.checkWheatherDestoried();
                copyinvokers = this.list(invocation);
                this.checkInvokers(copyinvokers, invocation);
            }
            Invoker<T> invoker = this.select(loadbalance, invocation, copyinvokers, invoked);
            invoked.add(invoker);
            RpcContext.getContext().setInvokers(invoked);
            int leftCycleTimes = invokers.size() - 1;
            try {
                URL url = invoker.getUrl();
                RpcStatus status = RpcStatus.getStatus(url, invocation.getMethodName());
                ThreadTruck.put((Object)DUBBOHANDSHAKE_KEY, (Object)Boolean.TRUE);
                Result result = invoker.invoke(invocation);
                Throwable e = result.getException();
                int invokeIdentify = invocation.hashCode();
                while (e instanceof HandShakeException) {
                    if (leftCycleTimes == 0) {
                        ThreadTruck.put((Object)DUBBOHANDSHAKE_KEY, (Object)Boolean.FALSE);
                    } else if (leftCycleTimes < 0) break;
                    --leftCycleTimes;
                    status.failedHandShake();
                    logger.warn(invokeIdentify + " handshakeerror for  " + url.getAddress() + "," + invocation.toString());
                    invoker = this.select(loadbalance, invocation, copyinvokers, invoked);
                    url = invoker.getUrl();
                    status = RpcStatus.getStatus(url, invocation.getMethodName());
                    invoked.add(invoker);
                    result = invoker.invoke(invocation);
                    e = result.getException();
                }
                if (!(e instanceof HandShakeException) && leftCycleTimes >= 0) {
                    status.sucessHandShake();
                }
                if (le != null && logger.isWarnEnabled()) {
                    logger.warn("Although retry the method " + invocation.getMethodName() + " in the service " + this.getInterface().getName() + " was successful by the provider " + invoker.getUrl().getAddress() + ", but there have been failed providers " + providers + " (" + providers.size() + "/" + copyinvokers.size() + ") from the registry " + this.directory.getUrl().getAddress() + " on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + ". Last error is: " + le.getMessage(), (Throwable)le);
                }
                Result result2 = result;
                return result2;
            }
            catch (RpcException e) {
                if (e.isBiz()) {
                    throw e;
                }
                le = e;
                continue;
            }
            catch (Throwable e) {
                le = new RpcException(e.getMessage(), e);
                continue;
            }
            finally {
                providers.add(invoker.getUrl().getAddress());
                ThreadTruck.put((Object)DUBBOHANDSHAKE_KEY, (Object)Boolean.FALSE);
            }
        }
        throw new RpcException(le != null ? le.getCode() : 0, "Failed to invoke the method " + invocation.getMethodName() + " in the service " + this.getInterface().getName() + ". Tried " + len + " times of the providers " + providers + " (" + providers.size() + "/" + copyinvokers.size() + ") from the registry " + this.directory.getUrl().getAddress() + " on the consumer " + NetUtils.getLocalHost() + " using the dubbo version " + Version.getVersion() + ". Last error is: " + (le != null ? le.getMessage() : ""), le != null && le.getCause() != null ? le.getCause() : le);
    }
}

