/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.http;

import com.alibaba.dubbo.rpc.protocol.http.KdContextCodec;
import com.alibaba.dubbo.rpc.protocol.http.RemoteInvocationResultWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.mservice.rpc.dubbo.context.KDInvokeContext;
import kd.bos.mservice.serialization.KServiceSerialization;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import kd.bos.mservice.spi.define.MServiceDefineMeta;
import kd.bos.service.InvokeService;
import kd.bos.service.invoke.MServiceFactory;
import kd.bos.thread.ThreadTruck;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.util.ClassUtils;
import org.springframework.web.util.NestedServletException;

public class ExtHttpInvokerServiceExporter
extends HttpInvokerServiceExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteInvocationResult invokeAndCreateResult(RemoteInvocation invocation, Object targetObject) {
        String kdInvokeContext = (String)((Object)invocation.getAttribute("CONSUMER_KDINVOKECONTEXT_KEY"));
        if (kdInvokeContext != null) {
            KDInvokeContext ctx = KdContextCodec.decode(kdInvokeContext);
            try {
                ThreadTruck.put((Object)"PROVIDER_KDINVOKECONTEXT_KEY", (Object)ctx);
                RemoteInvocationResult remoteInvocationResult = super.invokeAndCreateResult(invocation, targetObject);
                return remoteInvocationResult;
            }
            finally {
                ThreadTruck.remove((Object)"PROVIDER_KDINVOKECONTEXT_KEY");
            }
        }
        return super.invokeAndCreateResult(invocation, targetObject);
    }

    protected RemoteInvocation doReadRemoteInvocation(ObjectInputStream ois, String codecType) throws IOException, ClassNotFoundException {
        RemoteInvocation remoteInvocation;
        block4: {
            Class[] types;
            Object[] args;
            KServiceSerialization serializatier;
            block5: {
                boolean isBinaryCodec = KServiceSerializationFactory.isBinarySerialization((String)codecType);
                serializatier = KServiceSerializationFactory.getSerializer((String)codecType);
                Object obj = ois.readObject();
                if (!(obj instanceof RemoteInvocation)) {
                    throw new RemoteException("Deserialized object needs to be assignable to type [" + RemoteInvocation.class.getName() + "]: " + ClassUtils.getDescriptiveType((Object)obj));
                }
                remoteInvocation = (RemoteInvocation)obj;
                if (isBinaryCodec) break block4;
                args = remoteInvocation.getArguments();
                types = remoteInvocation.getParameterTypes();
                boolean isInvokeService = InvokeService.class.getName().equals(remoteInvocation.getAttribute("invokeInterfaceKey"));
                if (!isInvokeService) break block5;
                for (int i = 0; i < args.length; ++i) {
                    if (args[i] == null) continue;
                    args[i] = serializatier.deserialize((InputStream)new ByteArrayInputStream((byte[])args[i]), types[i]);
                }
                String serviceName = (String)args[0];
                String methodName = (String)args[1];
                Object[] parms = (Object[])args[2];
                if (parms == null) break block4;
                MServiceDefineMeta serviceDefine = MServiceFactory.getServiceDefine((String)serviceName);
                Object serviceObject = MServiceFactory.getService((String)serviceName);
                Method method = MServiceFactory.findServiceMethod(serviceObject.getClass(), (String)methodName, (int)parms.length);
                Class<?>[] paramTypes = method.getParameterTypes();
                for (int i = 0; i < parms.length; ++i) {
                    if (parms[i] == null) continue;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    serializatier.serialize(parms[i], (OutputStream)out);
                    parms[i] = serializatier.deserialize((InputStream)new ByteArrayInputStream(out.toByteArray()), paramTypes[i]);
                }
                break block4;
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                args[i] = serializatier.deserialize((InputStream)new ByteArrayInputStream((byte[])args[i]), types[i]);
            }
        }
        return remoteInvocation;
    }

    protected void writeRemoteInvocationResult(HttpServletRequest request, HttpServletResponse response, RemoteInvocationResult result, OutputStream os) throws IOException {
        if (result instanceof RemoteInvocationResultWrapper) {
            String dataCodecType = ((RemoteInvocationResultWrapper)result).getDataCodecType();
            response.addHeader("DATACODEC_TYPE_KEY", dataCodecType);
        }
        super.writeRemoteInvocationResult(request, response, result, os);
    }

    protected void doWriteRemoteInvocationResult(RemoteInvocationResult result, ObjectOutputStream oos) throws IOException {
        boolean isBinaryCodec = false;
        String dataCodecType = null;
        if (result instanceof RemoteInvocationResultWrapper) {
            dataCodecType = ((RemoteInvocationResultWrapper)result).getDataCodecType();
            result = ((RemoteInvocationResultWrapper)result).getResult();
            isBinaryCodec = KServiceSerializationFactory.isBinarySerialization((String)dataCodecType);
            if (isBinaryCodec) {
                oos.writeObject(result);
            } else {
                KServiceSerializationFactory.getSerializer((String)dataCodecType).serialize((Object)result, (OutputStream)oos);
            }
        } else {
            oos.writeObject(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RemoteInvocation readRemoteInvocation(HttpServletRequest request, InputStream is) throws IOException, ClassNotFoundException {
        RemoteInvocation remoteInvocation;
        try (ObjectInputStream ois = this.createObjectInputStream(this.decorateInputStream(request, is));){
            String codecType = request.getHeader("DATACODEC_TYPE_KEY");
            remoteInvocation = this.doReadRemoteInvocation(ois, codecType);
        }
        return remoteInvocation;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            RemoteInvocation ex = this.readRemoteInvocation(request);
            RemoteInvocationResult result = this.invokeAndCreateResult(ex, this.getProxy());
            String dataCodecType = (String)((Object)ex.getAttribute("DATACODEC_TYPE_KEY"));
            this.writeRemoteInvocationResult(request, response, new RemoteInvocationResultWrapper(result, dataCodecType));
        }
        catch (ClassNotFoundException arg4) {
            throw new NestedServletException("Class not found during deserialization", (Throwable)arg4);
        }
    }
}

