/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.rmi.RemoteException;
import kd.bos.mservice.serialization.KServiceSerializationFactory;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.util.ClassUtils;

public class ExtSimpleHttpInvokerRequestExecutor
extends SimpleHttpInvokerRequestExecutor {
    private static ThreadLocal<String> codectype = new ThreadLocal();
    private int readtimeout = -1;
    private int connetctimeout = -1;

    public ExtSimpleHttpInvokerRequestExecutor(int readtimeout, int connetctimeout) {
        this.readtimeout = readtimeout;
        this.connetctimeout = connetctimeout;
    }

    public void setCodecTypeBeforeExecute(String codecType) {
        codectype.set(codecType);
    }

    protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException {
        super.prepareConnection(con, contentLength);
        con.setReadTimeout(this.readtimeout);
        con.setConnectTimeout(this.connetctimeout);
        String type = codectype.get();
        if (type != null) {
            con.addRequestProperty("DATACODEC_TYPE_KEY", codectype.get());
        }
    }

    protected void doWriteRemoteInvocation(RemoteInvocation invocation, ObjectOutputStream oos) throws IOException {
        String codecType = (String)((Object)invocation.getAttribute("DATACODEC_TYPE_KEY"));
        boolean isBinaryCodec = KServiceSerializationFactory.isBinarySerialization((String)codecType);
        if (!isBinaryCodec) {
            Object[] args = invocation.getArguments();
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                ByteArrayOutputStream invokeBAOS = new ByteArrayOutputStream();
                KServiceSerializationFactory.getSerializer((String)codecType).serialize(args[i], (OutputStream)invokeBAOS);
                args[i] = invokeBAOS.toByteArray();
            }
            oos.writeObject(invocation);
        } else {
            oos.writeObject(invocation);
        }
    }

    protected RemoteInvocationResult doReadRemoteInvocationResult(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String codecType = codectype.get();
        boolean isBinaryCodec = KServiceSerializationFactory.isBinarySerialization((String)codecType);
        if (!isBinaryCodec) {
            return (RemoteInvocationResult)KServiceSerializationFactory.getSerializer((String)codecType).deserialize((InputStream)ois, RemoteInvocationResult.class);
        }
        Object obj = ois.readObject();
        if (!(obj instanceof RemoteInvocationResult)) {
            throw new RemoteException("Deserialized object needs to be assignable to type [" + RemoteInvocationResult.class.getName() + "]: " + ClassUtils.getDescriptiveType((Object)obj));
        }
        return (RemoteInvocationResult)obj;
    }
}

