/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.protocol.http;

import com.alibaba.dubbo.rpc.proxy.HexUtils;
import com.google.gson.Gson;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mservice.rpc.dubbo.context.KDInvokeContext;
import kd.bos.mservice.serializer.HessianSerializer;

public class KdContextCodec {
    public static final String TYPESPLITKEY = "{_@__}";
    public static final String CODETYPEKEY = "mservice.context.codec.type";
    private static Map<String, Codec> codeceres = new ConcurrentHashMap<String, Codec>(2);

    private static Codec getCodecer(String type) {
        return codeceres.computeIfAbsent(type, k -> {
            if ("hex".equals(type)) {
                return new Codec(){

                    @Override
                    public String encode(KDInvokeContext kdInvokeContextObj) {
                        return HexUtils.toHex(HessianSerializer.serialize((Object)kdInvokeContextObj));
                    }

                    @Override
                    public KDInvokeContext decode(String kdInvokeContext) {
                        return (KDInvokeContext)HessianSerializer.deserialize((byte[])HexUtils.fromHex(kdInvokeContext));
                    }
                };
            }
            if ("gson".equals(type)) {
                return new Codec(){

                    @Override
                    public String encode(KDInvokeContext kdInvokeContextObj) {
                        return new Gson().toJson((Object)kdInvokeContextObj);
                    }

                    @Override
                    public KDInvokeContext decode(String kdInvokeContext) {
                        return (KDInvokeContext)new Gson().fromJson(kdInvokeContext, KDInvokeContext.class);
                    }
                };
            }
            throw new KDException(BosErrorCode.actionNotFound, new Object[]{type + " not supported"});
        });
    }

    public static String encode(KDInvokeContext kdInvokeContextObj) {
        return KdContextCodec.getCodecer(System.getProperty(CODETYPEKEY, "gson")).encode(kdInvokeContextObj);
    }

    public static KDInvokeContext decode(String kdInvokeContext) {
        return KdContextCodec.getCodecer(System.getProperty(CODETYPEKEY, "gson")).decode(kdInvokeContext);
    }

    static interface Codec {
        public String encode(KDInvokeContext var1);

        public KDInvokeContext decode(String var1);
    }
}

