/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.proxy;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcInvocation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class InvokerInvocationHandler
implements InvocationHandler {
    private final Invoker<?> invoker;

    public InvokerInvocationHandler(Invoker<?> handler) {
        this.invoker = handler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke(this.invoker, args);
        }
        if (parameterTypes.length == 0 && "toString".equals(methodName)) {
            return this.invoker.toString();
        }
        if (parameterTypes.length == 0 && "hashCode".equals(methodName)) {
            return this.invoker.hashCode();
        }
        if (parameterTypes.length == 1 && "equals".equals(methodName)) {
            return this.invoker.equals(args[0]);
        }
        RpcInvocation invocation = new RpcInvocation(method, args);
        return this.invoker.invoke((Invocation)invocation).recreate();
    }
}

