/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ConsumerConfig;
import com.alibaba.dubbo.config.ProtocolConfig;
import com.alibaba.dubbo.config.ProviderConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.instance.Instance;
import kd.bos.mservice.common.limit.KServiceLimitUtil;
import kd.bos.mservice.rpc.dubbo.config.KDRegistryConfig;
import kd.bos.mservice.rpc.dubbo.registry.strategy.RegistryStrategyContext;
import kd.bos.resource.balancer.Configs;
import kd.bos.util.StringUtils;
import kd.bos.zk.ZKFactory;

public class DubboRegistryConfigs {
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private RegistryConfig backupRegistryConfig;
    private ProtocolConfig protocolConfig;
    private ProviderConfig providerConfig;
    private ConsumerConfig consumerConfig;
    private List<RegistryConfig> registryConfigs = new ArrayList<RegistryConfig>(2);
    private static Map<String, DubboRegistryConfigs> configsMap = new ConcurrentHashMap<String, DubboRegistryConfigs>();
    private static final String DUBBO_PROTOCOL_THREADS = "dubbo.protocol.threads";
    private static final String DUBBO_PROTOCOL_DISPATCH_THREADS = "dubbo.protocol.dispatch.threads";
    private static final String HEALTH_ACTIVE = "healthactive";

    private DubboRegistryConfigs() {
    }

    public static DubboRegistryConfigs getDubboRegistryConfigs(String protal) {
        return configsMap.computeIfAbsent(protal, k -> {
            DubboRegistryConfigs config = new DubboRegistryConfigs();
            config.registryConfig = RegistryStrategyContext.registryInit(new URL(null, null, 0).setProtocol(System.getProperty("dubbo.registry.protocol", "zookeeper")));
            config.applicationConfig = DubboRegistryConfigs.createApplicationConfig();
            config.protocolConfig = DubboRegistryConfigs.createProtocolConfig(protal);
            config.providerConfig = DubboRegistryConfigs.createProviderConfig(protal);
            config.consumerConfig = DubboRegistryConfigs.createConsumerConfig(protal);
            config.providerConfig.setProtocol(config.protocolConfig);
            config.providerConfig.setApplication(config.applicationConfig);
            config.consumerConfig.setApplication(config.applicationConfig);
            config.registryConfigs.add(config.registryConfig);
            boolean haEnable = Boolean.getBoolean("ha.component.enable");
            if (haEnable) {
                config.registryConfig.setCheck(Boolean.valueOf(false));
                config.backupRegistryConfig = DubboRegistryConfigs.createBackupRegistryConfig();
                config.backupRegistryConfig.setCheck(Boolean.valueOf(false));
                config.registryConfigs.add(config.backupRegistryConfig);
            }
            config.applicationConfig.setRegistries(config.registryConfigs);
            config.providerConfig.setRegistries(config.registryConfigs);
            config.consumerConfig.setRegistries(config.registryConfigs);
            return config;
        });
    }

    private static ConsumerConfig createConsumerConfig(String protocolName) {
        ConsumerConfig consumer = new ConsumerConfig();
        String timeout = System.getProperty("mservice.consumer.readTimeout");
        if (StringUtils.isNotEmpty((String)timeout)) {
            System.setProperty("dubbo.consumer.timeout", timeout);
        } else {
            timeout = System.getProperty("dubbo.consumer.timeout", "1000");
        }
        consumer.setTimeout(Integer.parseInt(timeout));
        String retries = System.getProperty("dubbo.consumer.retries", "0");
        consumer.setRetries(Integer.parseInt(retries));
        String loadbalance = System.getProperty("dubbo.consumers.loadbalance", HEALTH_ACTIVE);
        consumer.setLoadbalance(loadbalance);
        if ("leastactive".equals(loadbalance) || HEALTH_ACTIVE.equals(loadbalance)) {
            consumer.setFilter("activelimit");
        }
        String transClient = "dubbo".equals(protocolName) ? System.getProperty("dubbo.protocol.transporter", "netty4").trim() : ("http".equals(protocolName) ? System.getProperty("http.protocol.transporter", "simple").trim() : System.getProperty(protocolName + ".protocol.transporter", "20880").trim());
        consumer.setClient(transClient);
        return consumer;
    }

    private static ProviderConfig createProviderConfig(String protal) {
        String threads;
        String threadpool;
        ProviderConfig provider = new ProviderConfig();
        String timeout = System.getProperty("dubbo.provider.timeout", "1000");
        provider.setTimeout(Integer.parseInt(timeout));
        String retries = System.getProperty("dubbo.provider.retries", "0");
        provider.setRetries(Integer.parseInt(retries));
        String loadbalance = System.getProperty("dubbo.provider.loadbalance", HEALTH_ACTIVE);
        provider.setLoadbalance(loadbalance);
        String dispatcher = System.getProperty("dubbo.protocol.dispatcher");
        if (dispatcher != null) {
            provider.setDispatcher(dispatcher);
        }
        if ((threadpool = System.getProperty("dubbo.protocol.threadpool")) != null) {
            provider.setThreadpool(threadpool.trim());
        }
        if ((threads = System.getProperty(DUBBO_PROTOCOL_THREADS)) != null) {
            provider.setThreads(Integer.parseInt(threads.trim()));
        }
        provider.setInstanceId(Instance.getInstanceId());
        String server = "dubbo".equals(protal) ? System.getProperty("dubbo.protocol.transporter", "netty4") : ("http".equals(protal) ? System.getProperty("http.protocol.transporter", "tomcat") : System.getProperty(protal + ".protocol.transporter", "netty4"));
        provider.setServer(server);
        return provider;
    }

    private static ApplicationConfig createApplicationConfig() {
        String name = System.getProperty("dubbo.application.name", "ierp");
        ApplicationConfig ac = new ApplicationConfig(name);
        return ac;
    }

    private static ProtocolConfig createProtocolConfig(String protocolName) {
        ProtocolConfig protocol2 = new ProtocolConfig();
        protocol2.setName(protocolName);
        String dispatcher = System.getProperty("dubbo.protocol.dispatcher", "all");
        protocol2.setDispatcher(dispatcher);
        String threadpool = System.getProperty("dubbo.protocol.threadpool", "cached");
        protocol2.setThreadpool(threadpool);
        String threads = Configs.isRpcResourceBalanceEnable() ? System.getProperty(DUBBO_PROTOCOL_DISPATCH_THREADS, "30") : System.getProperty(DUBBO_PROTOCOL_THREADS, "200");
        protocol2.setThreads(Integer.valueOf(Integer.parseInt(threads.trim())));
        String port = "";
        port = "dubbo".equals(protocolName) ? System.getProperty("dubbo.protocol.port", "20880").trim() : ("http".equals(protocolName) ? System.getProperty("http.protocol.port", "2880").trim() : System.getProperty(protocolName + ".protocol.port", "20880").trim());
        protocol2.setPort(Integer.valueOf(Integer.parseInt(port)));
        long payload = KServiceLimitUtil.getLimitSize();
        protocol2.setPayload(Integer.valueOf((int)payload));
        String host = System.getProperty("dubbo.protocol.host");
        if (host != null) {
            protocol2.setHost(host);
        }
        return protocol2;
    }

    private static RegistryConfig createBackupRegistryConfig() {
        KDRegistryConfig registry = new KDRegistryConfig();
        String protocol2 = System.getProperty("dubbo.registry.protocol", "zookeeper");
        String url = System.getProperty("ha.zookeeper.backup");
        if (StringUtils.isEmpty((String)url) && (url == null || url.trim().length() == 0)) {
            throw new Error(String.format("Dubbo starting failed, %s is not configured.", "dubbo.registry.address.backup"));
        }
        registry.setAddress(ZKFactory.getZkAddress((String)url));
        registry.setProtocol(protocol2);
        if ("false".equals(System.getProperty("dubbo.registry.register"))) {
            registry.setRegister(false);
        }
        String dubboRPath = ZKFactory.getZkRootPath((String)url);
        registry.setFaultTolerant(true);
        String split = System.getProperty("dubbo.registry.clusterSplit");
        if ((split == null || "true".equals(split)) && Instance.getClusterName() != null) {
            registry.setRoot(dubboRPath + "kdubbo/" + Instance.getClusterName());
        } else {
            registry.setRoot(dubboRPath + "dubbo");
        }
        return registry;
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public RegistryConfig getRegistryConfig() {
        return this.registryConfig;
    }

    public RegistryConfig getBackupRegistryConfig() {
        return this.backupRegistryConfig;
    }

    public ProtocolConfig getProtocolConfig() {
        return this.protocolConfig;
    }

    public ProviderConfig getProviderConfig() {
        return this.providerConfig;
    }

    public ConsumerConfig getConsumerConfig() {
        return this.consumerConfig;
    }

    public List<RegistryConfig> getRegistryConfigs() {
        return this.registryConfigs;
    }
}

