/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo;

import com.alibaba.dubbo.config.ReferenceConfig;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.ErrorCode;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.debug.DebugUtil;
import kd.bos.mservice.rpc.dubbo.DubboBeanManager;
import kd.bos.mservice.rpc.dubbo.ProxyFactory;
import kd.bos.mservice.rpc.dubbo.debug.LocalDebugProxy;
import kd.bos.mservice.spi.rpc.MServiceLookup;
import kd.bos.util.AppUtils;

public class DubboServiceLookup
implements MServiceLookup {
    private static final Log log;
    private static ErrorCode errorCode;
    private static ConcurrentHashMap<String, Object> appIdInstanceMap;
    private static ConcurrentHashMap<String, Object> hostInstanceMap;
    private static boolean debugInstance;
    private static boolean canlooluplocal;

    public static boolean getCanlooluplocal() {
        return canlooluplocal;
    }

    public static ErrorCode getErrorCode() {
        return errorCode;
    }

    private <T> T lookupNotAppSplit(Class<T> clazz) {
        T bean;
        if (canlooluplocal && (bean = DubboBeanManager.getLocalServiceInstance(clazz)) != null) {
            return bean;
        }
        ReferenceConfig config = DubboBeanManager.getReferenceConfig(clazz.getName());
        if (config == null) {
            return null;
        }
        String key = clazz.getName() + "_";
        return (T)appIdInstanceMap.computeIfAbsent(key, k -> ProxyFactory.createProxyNoAppId(clazz));
    }

    public <T> T lookup(Class<T> clazz, String appId) {
        boolean debugMode = DebugUtil.isDebugMode();
        if (debugMode || debugInstance) {
            appId = "debug";
        }
        T obj = this.doLookupImpl(clazz, appId, "rpc", "javaobj");
        if (canlooluplocal) {
            obj = LocalDebugProxy.debugProxy(clazz, obj);
        }
        return obj;
    }

    public <T> T lookupHttp(Class<T> clazz, String appId, String dataCodecType) {
        boolean debugMode = DebugUtil.isDebugMode();
        if (debugMode || debugInstance) {
            appId = "debug";
        }
        T obj = this.doLookupImpl(clazz, appId, "http", dataCodecType);
        if (canlooluplocal) {
            obj = LocalDebugProxy.debugProxy(clazz, obj);
        }
        return obj;
    }

    private <T> T doLookupImpl(Class<T> clazz, String appId, String prototol, String dataCodecType) {
        T bean;
        if (!Instance.isAppSplit() && !AppUtils.isDeployAloneApp((String)appId)) {
            return this.lookupNotAppSplit(clazz);
        }
        if (canlooluplocal && (bean = DubboBeanManager.getLocalServiceInstance(clazz, appId)) != null) {
            return bean;
        }
        String key = clazz.getName() + ":" + appId + ":" + prototol + ":" + dataCodecType;
        return (T)appIdInstanceMap.computeIfAbsent(key, k -> ProxyFactory.createProxy(clazz, appId, prototol, dataCodecType));
    }

    public <T> T lookupEndpoint(Class<T> clazz, String ip, String port) {
        String key = clazz.getName() + "_" + ip + "_" + port;
        return (T)hostInstanceMap.computeIfAbsent(key, k -> ProxyFactory.createProxyEndpoint(clazz, ip, port));
    }

    static {
        block6: {
            log = LogFactory.getLog(DubboServiceLookup.class);
            errorCode = new ErrorCode("DubboServiceLookup", "%s");
            appIdInstanceMap = new ConcurrentHashMap();
            hostInstanceMap = new ConcurrentHashMap();
            debugInstance = false;
            canlooluplocal = true;
            debugInstance = Instance.isDebugInstance();
            if (debugInstance) {
                canlooluplocal = true;
            } else {
                try {
                    String str = System.getProperty("dubbo.service.lookup.local");
                    if (str != null) {
                        canlooluplocal = Boolean.parseBoolean(str);
                        break block6;
                    }
                    List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
                    for (String arg : args) {
                        if (!arg.startsWith("-agentlib:jdwp")) continue;
                        canlooluplocal = false;
                        break;
                    }
                }
                catch (Error | Exception e) {
                    log.warn(e);
                }
            }
        }
    }
}

