/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo;

import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.rpc.RpcException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.exception.DubboErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.gray.GrayStrategy;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.TerminationEvent;
import kd.bos.mservice.rpc.dubbo.DubboBeanManager;
import kd.bos.mservice.rpc.dubbo.DubboServiceLookup;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.PropertiesUtil;
import kd.bos.util.StringUtils;

public class ProxyFactory {
    public static <T> T createProxy(Class<T> model, String appId) {
        Handler handler = new Handler(model.getName(), appId);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{model}, (InvocationHandler)handler);
        return (T)proxy;
    }

    public static <T> T createProxy(Class<T> model, String appId, String prototol, String dataCodecType) {
        Handler handler = new Handler(model.getName(), appId);
        handler.setPrototol(prototol);
        handler.setDataCodecType(dataCodecType);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{model}, (InvocationHandler)handler);
        return (T)proxy;
    }

    protected static <T> T createProxyNoAppId(Class<T> model) {
        Handler handler = new Handler(model.getName(), null);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{model}, (InvocationHandler)handler);
        return (T)proxy;
    }

    public static <T> T createProxyEndpoint(Class<T> model, String ip, String port) {
        if (StringUtils.isEmpty((String)port)) {
            port = System.getProperty("dubbo.protocol.port", "20880");
        }
        Handler handler = new Handler(model.getName(), null, ip, port);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{model}, (InvocationHandler)handler);
        return (T)proxy;
    }

    private static class Handler
    implements InvocationHandler {
        private final String interfaze;
        private final String appId;
        private String host;
        private String ip;
        private String port;
        private String prototol = "rpc";
        private String dataCodecType = "javaobj";

        public Handler(String interfaze, String appId) {
            this.interfaze = interfaze;
            this.appId = appId;
        }

        public Handler(String interfaze, String appId, String ip, String port) {
            this.interfaze = interfaze;
            this.appId = appId;
            this.ip = ip;
            this.port = port;
            this.host = ip + ":" + port;
        }

        public void setDataCodecType(String dataCodecType) {
            this.dataCodecType = dataCodecType;
        }

        protected void setPrototol(String prototol) {
            this.prototol = prototol;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object bean = null;
            ReferenceConfig config = null;
            Throwable error = null;
            config = this.appId == null ? (this.host != null ? DubboBeanManager.getReferenceConfigEndpoint(this.interfaze, this.ip, this.port) : DubboBeanManager.getReferenceConfig(this.interfaze)) : DubboBeanManager.getReferenceConfigWithPrototol(this.interfaze, this.appId, this.prototol);
            error = null;
            if (config != null) {
                try {
                    bean = config.get();
                }
                catch (Error | Exception t) {
                    error = t;
                }
            }
            if (bean == null) {
                String partReason;
                String string = this.appId != null ? " by appId " + this.appId : (partReason = this.host != null ? " by endpoint " + this.host : "");
                if (error != null) {
                    if (error instanceof KDException) {
                        throw error;
                    }
                    throw new KDException(error, DubboServiceLookup.getErrorCode(), new Object[]{"Can't lookup mservice:" + this.interfaze + partReason});
                }
                throw new KDException(error, DubboServiceLookup.getErrorCode(), new Object[]{"Can't lookup mservice:" + this.interfaze + partReason + ", no consumer configured."});
            }
            try {
                Throwable throwable = null;
                try (MemSpanTrace span = MemSpanTrace.create((String)method.getDeclaringClass().getName(), (String)(method.getName() + this.toArrayString(args)));){
                    Object object;
                    if (this.appId != null) {
                        span.addTag("appid", this.appId);
                    }
                    try {
                        Object result;
                        ThreadTruck.put((Object)"DATACODEC_TYPE_KEY", (Object)this.dataCodecType);
                        object = result = method.invoke(bean, args);
                    }
                    catch (Throwable throwable2) {
                        try {
                            ThreadTruck.remove((Object)"DATACODEC_TYPE_KEY");
                            throw throwable2;
                        }
                        catch (Throwable result) {
                            throwable = result;
                            throw result;
                        }
                    }
                    ThreadTruck.remove((Object)"DATACODEC_TYPE_KEY");
                    return object;
                }
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException && (e = ((InvocationTargetException)e).getTargetException()) instanceof RpcException) {
                    String errorMsg = this.getDubboErrorMessage(this.appId, method, args, e);
                    if (e.getCause() != null && e.getCause() instanceof RemotingException) {
                        e = e.getCause();
                    }
                    if (e instanceof KDException) {
                        throw e;
                    }
                    String msg = StringUtils.isNotEmpty((String)errorMsg) ? errorMsg : "Exception in invoke " + this.interfaze + "(appId=" + this.getShowAppIdInException(this.appId) + "), error is: " + e.getMessage();
                    throw new KDException(e, DubboServiceLookup.getErrorCode(), new Object[]{msg});
                }
                if (e instanceof KDException) {
                    throw e;
                }
                throw new KDException(e, DubboServiceLookup.getErrorCode(), new Object[]{"Exception in invoke " + this.interfaze + "(appId=" + this.getShowAppIdInException(this.appId) + "), error is: " + e.getMessage()});
            }
        }

        private String getShowAppIdInException(String appId) {
            if (appId == null) {
                return "";
            }
            if ("custom".equals(appId)) {
                return "custom[" + ThreadTruck.get((Object)"customForLastestAppid") + "]";
            }
            return appId;
        }

        private String toArrayString(Object[] args) {
            try {
                StringBuilder sb = new StringBuilder("[");
                for (Object o : args) {
                    if (o == null) continue;
                    if (o instanceof Object[]) {
                        sb.append(Arrays.toString((Object[])o));
                    } else {
                        sb.append(o);
                    }
                    sb.append(" , ");
                }
                sb.setLength(sb.length() - 2);
                sb.append("]");
                if (sb.length() > 3000) {
                    sb.setLength(3000);
                    sb.append(".......");
                }
                return sb.toString();
            }
            catch (Error | Exception e) {
                return Arrays.toString(args);
            }
        }

        private String getDubboErrorMessage(String appId, Method method, Object[] args, Throwable e) {
            String errorMsg;
            String logId = TraceIdUtil.idToHex((long)TraceIdUtil.createId());
            String fullApiName = this.getApiName(method.getDeclaringClass().getName() + "." + method.getName(), args, appId);
            String appIdName = PropertiesUtil.getAppIdName((String)appId);
            String appgroup = GrayStrategy.getAppGroup((String)appId);
            appgroup = "defaultGroup".equals(appgroup) ? "" : appgroup + ".";
            appIdName = (appIdName == null ? "" : appIdName) + (appId == null ? "" : "(" + appgroup + appId + ")");
            int errorCode = ((RpcException)e).getCode();
            if (DubboErrorCode.providerTimeOut.getCode() == errorCode) {
                RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
                if (requestTimeoutContext != null && requestTimeoutContext.isAutomaticTimeout()) {
                    errorMsg = DubboErrorCode.getMsgByCode((int)errorCode, (String)fullApiName, (String)appIdName, (String)logId, (String)String.valueOf(requestTimeoutContext.getTimeout() / 1000L), (Throwable)e);
                    EventDataReporter.report((EventType)TerminationEvent.WebAutoTimeoutEvent.getInstance(), (String)errorMsg, (Throwable)e);
                } else {
                    errorMsg = DubboErrorCode.getMsgByCode((int)errorCode, (String)fullApiName, (String)appIdName, (String)logId, (Throwable)e);
                    EventDataReporter.report((EventType)TerminationEvent.RpcTimeoutEvent.getInstance(), (String)errorMsg, (Throwable)e);
                }
            } else {
                errorMsg = DubboErrorCode.getMsgByCode((int)errorCode, (String)fullApiName, (String)appIdName, (String)logId, (Throwable)e);
            }
            return errorMsg;
        }

        private String getApiName(String classMethodName, Object[] args, String appId) {
            if ("kd.bos.service.DispatchService.invoke".equals(classMethodName) && args.length > 2) {
                String urlMethodName;
                StringBuilder apiNameBuild = new StringBuilder();
                String serviceName = String.valueOf(args[1]);
                String methodName = String.valueOf(args[2]);
                if ("batchInvokeAction".equals(methodName) && StringUtils.isNotEmpty((String)(urlMethodName = (String)InnerThreadTruck.get((Object)"batchInvokeAction")))) {
                    methodName = "(" + urlMethodName.replace(appId + ".", "") + ")";
                }
                String fullApiName = apiNameBuild.append(serviceName).append(":").append(methodName).toString();
                return fullApiName;
            }
            return classMethodName;
        }
    }
}

