/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.debug;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Exporter;
import com.alibaba.dubbo.rpc.ExporterListener;
import com.alibaba.dubbo.rpc.RpcException;
import kd.bos.mservice.debug.DebugUtil;
import kd.bos.mservice.debug.conf.DebugAttachConf;
import kd.bos.mservice.rpc.dubbo.debug.DubboDebugUtil;

@Activate
public class DebugServiceExporterListener
implements ExporterListener {
    public static final String NAME = "kd_debug_exporter_listener";

    public void exported(Exporter<?> exporter) throws RpcException {
        URL url = exporter.getInvoker().getUrl();
        DebugUtil.debug((String)("exported " + (url.isLocalHost() ? "local" : "remote") + "\t" + url.toIdentityString()));
    }

    public void unexported(Exporter<?> exporter) {
        URL url = exporter.getInvoker().getUrl();
        DebugUtil.debug((String)("unexported " + url.toIdentityString()));
        if (!url.isLocalHost()) {
            DebugAttachConf.get().detachByRouteKey(DubboDebugUtil.getRouteKey(url));
        }
    }
}

