/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.metric.Counter;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;

@Activate(group={"consumer"}, before={"traceConsumer"})
public class ConsumerMetricFilter
implements Filter {
    public static final String THREAD_SERVICE_KEY = "metric.service";
    private static final String CONFIG_PREFIX_KEY = "metric.dubbo.prefix";
    private String prefix = "kd.metrics.dubbo.";
    private Timer requestTimer;
    private Meter errorsMeter;
    private Meter timeoutMeter;
    private Counter activeRequests;
    private ConcurrentHashMap<String, Timer> requestTimerByService = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Meter> errorsMeterByService = new ConcurrentHashMap();

    public ConsumerMetricFilter() {
        this.prefix = System.getProperty(CONFIG_PREFIX_KEY, this.prefix);
        this.requestTimer = MetricSystem.timer((String)this.name("consumer.requestTimer"));
        this.errorsMeter = MetricSystem.meter((String)this.name("consumer.errors"));
        this.timeoutMeter = MetricSystem.meter((String)this.name("consumer.timeouts"));
        this.activeRequests = MetricSystem.counter((String)this.name("consumer.activeRequests"));
    }

    private String name(String suffix) {
        return this.prefix + suffix;
    }

    private Timer getRequestTimerByService(String serviceName) {
        Timer timer = this.requestTimerByService.get(serviceName);
        if (timer != null) {
            return timer;
        }
        timer = MetricSystem.timer((String)this.name("consumer.requestTimer." + serviceName));
        this.requestTimerByService.putIfAbsent(serviceName, timer);
        return timer;
    }

    private Meter getErrorsMeterByService(String serviceName) {
        Meter meter = this.errorsMeterByService.get(serviceName);
        if (meter != null) {
            return meter;
        }
        meter = MetricSystem.meter((String)this.name("consumer.errors." + serviceName));
        this.errorsMeterByService.putIfAbsent(serviceName, meter);
        return meter;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String service = this.getServiceName(invoker, invocation);
        this.activeRequests.inc();
        Timer.Context context = this.requestTimer.time();
        Timer.Context contextByService = this.getRequestTimerByService(service).time();
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        catch (Exception e) {
            this.errorsMeter.mark();
            this.getErrorsMeterByService(service).mark();
            if (e instanceof RpcException) {
                if (((RpcException)((Object)e)).isTimeout()) {
                    this.timeoutMeter.mark();
                } else if (((RpcException)((Object)e)).isNetwork()) {
                    this.timeoutMeter.mark();
                }
                throw (RpcException)((Object)e);
            }
            throw new RpcException((Throwable)e);
        }
        finally {
            context.stop();
            contextByService.stop();
            this.activeRequests.dec();
        }
    }

    private String getServiceName(Invoker<?> invoker, Invocation invocation) {
        String type = invoker.getUrl().getParameter("interface");
        String method = invocation.getMethodName();
        return type + "." + method;
    }
}

