/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.filter;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.remoting.TimeoutException;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import kd.bos.context.RequestTimeoutContext;
import kd.bos.exception.DubboErrorCode;
import kd.bos.govern.timeout.TimeoutHandleFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.rpc.dubbo.filter.DubboArgumentsParser;
import kd.bos.mservice.sdk.thread.InnerThreadTruck;
import kd.bos.util.StringUtils;

@Activate(group={"consumer"}, order=-10000)
public class ConsumerTimeoutFilter
implements Filter {
    private static final Log log = LogFactory.getLog(ConsumerTimeoutFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        TimeoutHandleFactory.get().handleManuallyTimeout();
        URL url = invoker.getUrl();
        String[] serviceMethodArr = DubboArgumentsParser.getServiceAndMethodName(invoker, invocation);
        String serviceName = serviceMethodArr[0];
        String methodName = serviceMethodArr[1];
        if ("batchInvokeAction".equals(methodName)) {
            methodName = (String)InnerThreadTruck.get((Object)"batchInvokeAction");
        }
        String fullApiName = serviceName + ":" + methodName;
        RequestTimeoutContext requestTimeoutContext = RequestTimeoutContext.get();
        String appId = url.getParameter("group");
        if (requestTimeoutContext != null) {
            requestTimeoutContext.setAppId(appId);
            if (requestTimeoutContext.isWebRequest()) {
                requestTimeoutContext.setRequestOperation(fullApiName);
            }
            if (requestTimeoutContext.isAutomaticTimeout()) {
                if (!requestTimeoutContext.isTimeoutExceptionThrown()) {
                    this.setWebRequestTimeout(requestTimeoutContext);
                }
                String nextServerIp = invoker.getUrl().getIp();
                requestTimeoutContext.setNextServerIp(nextServerIp);
                return invoker.invoke(invocation);
            }
        } else {
            RequestTimeoutContext.set((RequestTimeoutContext)new RequestTimeoutContext("RpcRequest", fullApiName, Integer.MAX_VALUE).setAppId(appId));
        }
        try {
            String appServiceMethod;
            String originalServiceName;
            Object[] arguments = invocation.getArguments();
            if ("batchInvokeAction".equals(methodName)) {
                methodName = (String)InnerThreadTruck.get((Object)"batchInvokeAction");
            }
            if ("cloud.bos.endPointService".equals(serviceName)) {
                RpcContext.getContext().setAttachment("customRpcTimeout", System.getProperty("cloud.bos.endPointService.invoke.timeout", "30000"));
            }
            if (("kd.bos.service.DispatchService".equals(originalServiceName = invoker.getInterface().getName()) || "kd.bos.service.InvokeService".equals(originalServiceName)) && null != arguments && arguments.length >= 3) {
                String appServiceFactory = String.valueOf(arguments[0]);
                appServiceMethod = appServiceFactory + "." + serviceName + "." + methodName + ".timeout";
            } else {
                appServiceMethod = serviceName + "." + methodName + ".timeout";
            }
            String customRpcTimeout = System.getProperty(appServiceMethod);
            if (StringUtils.isNotEmpty((String)customRpcTimeout)) {
                RpcContext.getContext().setAttachment("customRpcTimeout", customRpcTimeout);
            } else {
                this.setRpcConfigTimeout(appId, serviceName, methodName);
            }
        }
        catch (Exception e) {
            log.warn((Throwable)e);
        }
        return invoker.invoke(invocation);
    }

    private void setWebRequestTimeout(RequestTimeoutContext requestTimeoutContext) {
        long timeout;
        long costTime = System.currentTimeMillis() - requestTimeoutContext.getStartTime();
        if (costTime > (timeout = requestTimeoutContext.getTimeout())) {
            throw new RpcException(DubboErrorCode.webRequestTimeOut.getCode(), (Throwable)new TimeoutException(DubboErrorCode.webRequestTimeOut.getCode(), false, null, String.format("Request timeout,The web request has taken: %s s,the timeout is: %s s", costTime / 1000L, timeout / 1000L)));
        }
        long surplusTimeout = timeout - costTime;
        RpcContext.getContext().setAttachment("customRpcTimeout", String.valueOf(surplusTimeout));
    }

    private void setRpcConfigTimeout(String appId, String serviceName, String methodName) {
        StringBuilder apiNameBuild = new StringBuilder();
        String fullApiName = StringUtils.isNotEmpty((String)appId) ? apiNameBuild.append("mservice.rpc.").append(appId).append(".").append(serviceName).append(":").append(methodName).toString() : apiNameBuild.append("mservice.rpc.").append(serviceName).append(":").append(methodName).toString();
        String customRpcTimeout = System.getProperty(fullApiName);
        if (StringUtils.isNotEmpty((String)customRpcTimeout)) {
            RpcContext.getContext().setAttachment("customRpcTimeout", customRpcTimeout);
        } else {
            apiNameBuild = new StringBuilder();
            fullApiName = StringUtils.isNotEmpty((String)appId) ? apiNameBuild.append(appId).append(".").append(serviceName).append(":").append(methodName).toString() : apiNameBuild.append(serviceName).append(":").append(methodName).toString();
            customRpcTimeout = System.getProperty(fullApiName);
            if (StringUtils.isNotEmpty((String)customRpcTimeout)) {
                RpcContext.getContext().setAttachment("customRpcTimeout", customRpcTimeout);
            }
        }
    }
}

