/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.api.Probe;
import kd.bos.metric.Counter;
import kd.bos.metric.Meter;
import kd.bos.metric.MetricSystem;
import kd.bos.metric.Timer;

@Activate(group={"provider"}, order=-6000)
public class ProviderMetricFilter
implements Filter {
    private static final String CONFIG_PREFIX_KEY = "metric.dubbo.prefix";
    private static String prefix = "kd.metrics.dubbo.";
    private Timer requestTimer;
    private Meter errorsMeter;
    private Counter activeRequests;
    private ConcurrentHashMap<String, Timer> requestTimerByService = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Meter> errorsMeterByService = new ConcurrentHashMap();

    public ProviderMetricFilter() {
        prefix = System.getProperty(CONFIG_PREFIX_KEY, prefix);
        this.requestTimer = MetricSystem.timer((String)this.name("provider.requestTimer"));
        this.errorsMeter = MetricSystem.meter((String)this.name("provider.errors"));
        this.activeRequests = MetricSystem.counter((String)this.name("provider.activeRequests"));
    }

    private Timer getRequestTimerByService(String serviceName) {
        Timer timer = this.requestTimerByService.get(serviceName);
        if (timer != null) {
            return timer;
        }
        timer = MetricSystem.timer((String)this.name("provider.requestTimer." + serviceName));
        this.requestTimerByService.putIfAbsent(serviceName, timer);
        return timer;
    }

    private Meter getErrorsMeterByService(String serviceName) {
        Meter meter = this.errorsMeterByService.get(serviceName);
        if (meter != null) {
            return meter;
        }
        meter = MetricSystem.meter((String)this.name("provider.errors." + serviceName));
        this.errorsMeterByService.putIfAbsent(serviceName, meter);
        return meter;
    }

    private String name(String suffix) {
        return prefix + suffix;
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String service = this.getServiceName(invoker, invocation);
        this.activeRequests.inc();
        Probe.touch((String)"rpc");
        Timer.Context context = this.requestTimer.time();
        Timer.Context contextByService = this.getRequestTimerByService(service).time();
        try {
            Result result = invoker.invoke(invocation);
            return result;
        }
        catch (Exception e) {
            this.errorsMeter.mark();
            this.getErrorsMeterByService(service).mark();
            if (e instanceof RpcException) {
                throw (RpcException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RpcException((Throwable)e);
        }
        finally {
            context.stop();
            contextByService.stop();
            this.activeRequests.dec();
        }
    }

    private String getServiceName(Invoker<?> invoker, Invocation invocation) {
        String type = invoker.getUrl().getParameter("interface");
        String method = invocation.getMethodName();
        return type + "." + method;
    }
}

