/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.alibaba.dubbo.rpc.protocol.dubbo.DecodeableRpcResult;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.cache.redis.CacheLimiter;
import kd.bos.context.CustomRouteMap;
import kd.bos.context.KdtxRequestContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.db.DBLimiter;
import kd.bos.db.tx.Propagation;
import kd.bos.db.tx.TX;
import kd.bos.debug.DebugInfo;
import kd.bos.instance.Instance;
import kd.bos.mservice.debug.DebugUtil;
import kd.bos.mservice.monitor.MserviceStatus;
import kd.bos.mservice.monitor.MserviceStatusManger;
import kd.bos.mservice.rpc.dubbo.context.KDInvokeContext;
import kd.bos.mservice.rpc.dubbo.debug.DubboDebugUtil;
import kd.bos.mservice.rpc.dubbo.rpc.RequestStatus;
import kd.bos.mservice.rpc.dubbo.rpc.ResultWrapper;
import kd.bos.response.ResponseHeader;
import kd.bos.response.ResponseHeaderManage;
import kd.bos.slowlog.SlowLogger;
import kd.bos.thread.SetThreadName;
import kd.bos.thread.ThreadTruck;
import kd.bos.trace.tracer.SlowConfig;
import kd.bos.trace.tracer.TraceStatistics;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.MaskUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.bos.util.resource.Resources;

@Activate(group={"provider", "consumer"}, order=1000, before={"exception"})
public class RequestContextFilter
implements Filter {
    private static final String AUDIT_NAME = "dubbo_cost";
    public static final String CLIENT_INSTANCE_ID = "clientInstanceId";
    public static final String CONSUMER_KDINVOKECONTEXT_KEY = "CONSUMER_KDINVOKECONTEXT_KEY";
    public static final String PROVIDER_KDINVOKECONTEXT_KEY = "PROVIDER_KDINVOKECONTEXT_KEY";
    public static final String DATACODEC_TYPE_KEY = "DATACODEC_TYPE_KEY";
    private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final String KEY_LOGPARAMS_ENABLE = "SlowLogger.rpc.params.enable";

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (RpcContext.getContext().isConsumerSide()) {
            return this.invokeConsumerSide(invoker, invocation);
        }
        return this.invokeProviderSide(invoker, invocation);
    }

    /*
     * Loose catch block
     */
    private Result invokeConsumerSide(Invoker<?> invoker, Invocation invocation) {
        try {
            KDInvokeContext ctx = this.setupConsumerSideContext(invocation);
            ThreadTruck.put((Object)CONSUMER_KDINVOKECONTEXT_KEY, (Object)ctx);
            try (Auditable audit = Audit.audit((String)AUDIT_NAME, (Object[])new Object[]{"consumer", invocation.getAttachment("interface"), invocation.getMethodName()});){
                Result result = invoker.invoke(invocation);
                if (result instanceof DecodeableRpcResult) {
                    KDInvokeContext invokeContext = ((DecodeableRpcResult)result).getInvokeContext();
                    ResponseHeader resHeader = invokeContext.getResHeader();
                    KdtxRequestContext krc = invokeContext.getKdtxRequestContext();
                    KdtxRequestContext.set((KdtxRequestContext)krc);
                    ResponseHeaderManage.merge((ResponseHeader)resHeader);
                }
                ResultWrapper resultWrapper = new ResultWrapper(result, ctx);
                return resultWrapper;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.takeContext(invocation);
            ThreadTruck.remove((Object)CONSUMER_KDINVOKECONTEXT_KEY);
        }
    }

    private KDInvokeContext setupConsumerSideContext(Invocation invocation) throws RpcException {
        KDInvokeContext ctx = new KDInvokeContext();
        ctx.setDataCodecType((String)ThreadTruck.get((Object)DATACODEC_TYPE_KEY));
        ctx.setRequestContext(RequestContext.get());
        ctx.setKdtxRequestContext(KdtxRequestContext.get());
        if (ctx.getRequestContext() == null) {
            throw new RpcException(Resources.getString((String)"\u65e0\u8bf7\u6c42\u4e0a\u4e0b\u6587(\u672a\u767b\u5f55)\uff0c\u4e0d\u5141\u8bb8\u8c03\u7528\u5fae\u670d\u52a1\u3002", (String)"RequestContextFilter_0", (String)"bos-mservice-dubbox", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)RequestContext.get().getTraceId())) {
            RequestContext.get().setTraceId(TraceIdUtil.createTraceIdString());
        }
        ctx.setCallerHasTransaction(TX.getPropagation() != Propagation.NOT_SUPPORTED || TX.__isCrossCallerHasTransaction());
        Map routeMap = CustomRouteMap.getRouteMap();
        if (!routeMap.isEmpty()) {
            ctx.setEntityDBRouteMap(routeMap);
        }
        ((RpcInvocation)invocation).setInvokeContext(ctx);
        ((RpcInvocation)invocation).setAttachment(CLIENT_INSTANCE_ID, Instance.getInstanceId());
        return ctx;
    }

    private KDInvokeContext takeContext(Invocation invocation) {
        KDInvokeContext ctx = ((RpcInvocation)invocation).getInvokeContext();
        if (ctx != null) {
            TX.__setCrossCallerHasTransaction((boolean)ctx.isCallerHasTransaction());
            ((RpcInvocation)invocation).setInvokeContext(null);
            return ctx;
        }
        return null;
    }

    private void setupProviderSideContext(KDInvokeContext ctx) {
        RequestContext rc = ctx.getRequestContext();
        RequestContext.set((RequestContext)rc);
        KdtxRequestContext kdtxRequestContext = ctx.getKdtxRequestContext();
        KdtxRequestContext.set((KdtxRequestContext)kdtxRequestContext);
        DebugInfo.setupThreadDebug((DebugInfo)rc.getDebugInfo());
        Map<String, String> routeMap = ctx.getEntityDBRouteMap();
        if (routeMap != null) {
            for (Map.Entry<String, String> entity : routeMap.entrySet()) {
                CustomRouteMap.setDBRouteKey((String)entity.getKey(), (String)entity.getValue());
            }
        }
        TraceIdUtil.setCurrentTraceId((String)rc.getTraceId());
        RequestContextThreadBinder.bind((RequestContext)rc);
        SetThreadName.convertDubboToRpcServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result invokeProviderSide(Invoker<?> invoker, Invocation invocation) {
        KDInvokeContext ctx;
        RpcInvocation rpcInvocation = (RpcInvocation)invocation;
        if (rpcInvocation.getInvokeContext() == null) {
            ctx = (KDInvokeContext)ThreadTruck.get((Object)PROVIDER_KDINVOKECONTEXT_KEY);
            rpcInvocation.setInvokeContext(ctx);
        }
        ctx = this.takeContext(invocation);
        RequestStatus.requestApp(invoker.getUrl().getParameter("group"));
        try {
            Result result = DubboDebugUtil.invoke(ctx, () -> {
                String traceId = "";
                if (ctx != null) {
                    traceId = ctx.getRequestContext().getTraceId();
                    this.setupProviderSideContext(ctx);
                }
                int invokerCostTime = 0;
                try {
                    try (Auditable audit = Audit.audit((String)AUDIT_NAME, (Object[])new Object[]{"provider", invocation.getAttachment("interface"), invocation.getMethodName()});){
                        long startInvokeTime = System.currentTimeMillis();
                        Result result = invoker.invoke(invocation);
                        invokerCostTime = (int)(System.currentTimeMillis() - startInvokeTime);
                        MserviceStatus servicestatus = MserviceStatusManger.getMserviceStatus();
                        ctx.setStatus(servicestatus);
                        ResponseHeader resHeader = ResponseHeader.get();
                        if (!resHeader.isEmpty()) {
                            ctx.setResHeader(resHeader);
                        }
                        ctx.setKdtxRequestContext(KdtxRequestContext.get());
                        ResultWrapper resultWrapper = new ResultWrapper(result, ctx);
                        return resultWrapper;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.staticSlowLog(invokerCostTime, invocation, ctx.getRequestContext().getClientUrl(), traceId);
                }
            }, () -> invoker.getInterface().getName() + "." + invocation.getMethodName() + "(" + DebugUtil.argumentsInfo((Object[])invocation.getArguments()) + ")");
            return result;
        }
        catch (Error | Exception t) {
            TX.setResponseException((Throwable)t);
            throw new RpcException(t);
        }
        finally {
            try {
                TX.checkLeak();
            }
            finally {
                CacheLimiter.end();
                DBLimiter.end();
                try {
                    Audit.finallyAudit();
                }
                finally {
                    try {
                        ThreadLocals.release();
                    }
                    finally {
                        RequestContext.set(null);
                    }
                }
            }
        }
    }

    private void staticSlowLog(int cost, Invocation invocation, String clientUrl, String traceId) {
        boolean force;
        boolean bl = force = cost > SlowConfig.getSlowTime((String)"rpcRequest");
        if (force) {
            String statics;
            String params;
            String identity = invocation.getInvoker().getUrl().toIdentityString();
            Class[] argTypes = invocation.getParameterTypes();
            Object[] arguments = invocation.getArguments();
            if (ConfigurationUtil.getBoolean((String)"SlowLogger.params.mask.enable", (Boolean)true).booleanValue()) {
                try {
                    params = RequestContextFilter.getMaskParamStr(argTypes, arguments);
                }
                catch (Exception e) {
                    params = RequestContextFilter.getParamStr(argTypes, arguments);
                }
            } else {
                params = RequestContextFilter.getParamStr(argTypes, arguments);
            }
            String msg = "SlowLogger-RPC: cost " + cost + "ms,time is:" + dateTimeFormatter.format(LocalDateTime.now()) + ",traceId is:" + traceId;
            msg = msg + "\r\n the invoker is:\r\n    " + clientUrl;
            msg = msg + "\r\n the invokeMehod is:\r\n    " + identity;
            if (this.isSlowLoggerParamsEnable()) {
                msg = msg + "\r\n the invokeParam is:\r\n    " + params;
            }
            if (StringUtils.isNotEmpty((String)(statics = TraceStatistics.getThreadTraceStatistic((Thread)Thread.currentThread())))) {
                msg = msg + "\r\n the statics is:\r\n" + statics.replaceAll("&nbsp;", " ").replaceAll("<br>", "\n");
            }
            SlowLogger.log((String)msg, (Object[])new Object[]{"SlowLogger", cost});
            SlowLogger.count((String)"RPC");
        }
    }

    private static String getParamStr(Class[] argTypes, Object[] arguments) {
        StringBuilder paramStr = new StringBuilder("(");
        for (int i = 0; i < argTypes.length; ++i) {
            if (argTypes[i] == Object[].class) {
                paramStr.append("[").append(Arrays.toString((Object[])arguments[i])).append("]");
            } else {
                paramStr.append(arguments[i]);
            }
            paramStr.append(",");
        }
        paramStr.append(")");
        return paramStr.toString();
    }

    private static String getMaskParamStr(Class[] argTypes, Object[] arguments) {
        int reserveLength = ConfigurationUtil.getInteger((String)"SlowLogger.params.mask.reserve", (Integer)2);
        StringBuilder paramStr = new StringBuilder("(");
        for (int i = 0; i < argTypes.length; ++i) {
            if (argTypes[i] == Object[].class) {
                paramStr.append("[");
                Object[] argumentsArr = (Object[])arguments[i];
                Object[] maskedArr = new Object[argumentsArr.length];
                for (int j = 0; j < argumentsArr.length; ++j) {
                    String masked = MaskUtil.maskJsonString((String)String.valueOf(argumentsArr[j]), (int)reserveLength);
                    maskedArr[j] = masked;
                }
                paramStr.append(Arrays.toString(maskedArr)).append("]");
            } else {
                String masked = MaskUtil.maskJsonString((String)String.valueOf(arguments[i]), (int)reserveLength);
                paramStr.append(masked);
            }
            paramStr.append(",");
        }
        paramStr.append(")");
        return paramStr.toString();
    }

    private boolean isSlowLoggerParamsEnable() {
        String str = System.getProperty(KEY_LOGPARAMS_ENABLE);
        if (str != null) {
            return "true".equalsIgnoreCase(str);
        }
        return true;
    }
}

