/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.filter.trace;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import java.util.Map;
import kd.bos.mservice.rpc.dubbo.filter.DubboArgumentsParser;
import kd.bos.mservice.rpc.dubbo.filter.trace.DubboSpanExtractor;
import kd.bos.mservice.rpc.dubbo.filter.trace.DubboSpanInjector;
import kd.bos.mservice.rpc.dubbo.filter.trace.DubboTraceProperties;
import kd.bos.service.DispatchService;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.core.InnerFactory;
import kd.bos.trace.core.InnerSpan;
import kd.bos.trace.core.InnerTracer;
import kd.bos.trace.core.Sampler;
import kd.bos.trace.core.SpanInjector;
import kd.bos.trace.sampler.NeverSampler;
import kd.bos.util.NetAddressUtils;
import kd.bos.util.StringUtils;

@Activate(group={"provider"}, order=-7000)
public class ProviderSpanFilter
implements Filter {
    private DubboSpanExtractor spanExtractor = new DubboSpanExtractor();
    private SpanInjector<RpcContext> spanInjector = new DubboSpanInjector();
    private String ip = NetAddressUtils.getLocalIpAddress();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        boolean isTraceDubbo = DubboTraceProperties.isTraceEnable() && TraceConfig.isTraceEnable();
        InnerTracer tracer = null;
        InnerSpan parentSpan = null;
        InnerSpan childSpan = null;
        try {
            tracer = InnerFactory.getTracer();
            if (isTraceDubbo) {
                Map attachments = RpcContext.getContext().getAttachments();
                parentSpan = this.spanExtractor.joinTrace(RpcContext.getContext());
                boolean skip = "0".equals(attachments.get("X-B3-Sampled"));
                String spanName = "provider(" + this.ip + ")" + invocation.getMethodName();
                StringBuilder serviceNameBuild = new StringBuilder(spanName);
                String[] serviceMethodArr = DubboArgumentsParser.getServiceAndMethodName(invoker, invocation);
                String serviceName = serviceMethodArr[0];
                String methodName = serviceMethodArr[1];
                if ("batchInvokeAction".equals(methodName)) {
                    methodName = (String)attachments.get("batchInvokeAction");
                }
                String appId = invoker.getUrl().getParameter("group");
                serviceNameBuild.append("[").append(serviceName).append(".").append(methodName).append("]");
                if (StringUtils.isNotEmpty((String)appId)) {
                    serviceNameBuild.append("/").append(appId);
                }
                if (parentSpan != null) {
                    childSpan = tracer.createSpan(serviceNameBuild.toString(), parentSpan, true);
                    parentSpan.logEvent("sr");
                } else {
                    childSpan = skip ? tracer.createSpan(spanName, (Sampler)NeverSampler.INSTANCE) : tracer.createSpan(serviceNameBuild.toString(), true);
                    childSpan.logEvent("sr");
                }
                childSpan.tag("service", this.getServiceName(invoker));
                this.spanInjector.inject(childSpan, (Object)RpcContext.getContext());
            }
            Result result = invoker.invoke(invocation);
            String reqid = invocation.getAttachment("RPC.RequestId");
            if (reqid != null && childSpan != null) {
                childSpan.tag("RPC.RequestId", reqid);
                invocation.getAttachments().remove("RPC.RequestId");
            }
            Result result2 = result;
            return result2;
        }
        finally {
            if (isTraceDubbo) {
                if (parentSpan != null) {
                    parentSpan.logEvent("ss");
                    parentSpan.stop();
                } else if (childSpan != null) {
                    childSpan.logEvent("ss");
                }
                if (childSpan != null) {
                    tracer.close(childSpan);
                }
            }
        }
    }

    private String getServiceName(Invoker<?> invoker) {
        String type = invoker.getUrl().getParameter("interface");
        if (DispatchService.class.getName().equals(type)) {
            return "RpcService";
        }
        return type.substring(type.lastIndexOf(".") + 1);
    }
}

