/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.registry.strategy.kregistrycenter;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.RegistryConfig;
import kd.bos.mservice.rpc.dubbo.config.KDRegistryConfig;
import kd.bos.mservice.rpc.dubbo.registry.strategy.AbstractRegistryStrategy;
import kd.bos.mservice.rpc.dubbo.registry.strategy.nacos.NacosRegistryStrategy;
import kd.bos.mservice.rpc.dubbo.registry.strategy.zk.ZookeeperRegistryStrategy;

public class KCommonRegistryStrategy
implements AbstractRegistryStrategy {
    @Override
    public RegistryConfig createRegistryConfig(URL url) {
        String rtype = System.getProperty("kregistrycenter.registry.type");
        AbstractRegistryStrategy registryStrategy = null;
        if ("zookeeper".equals(rtype)) {
            registryStrategy = new ZookeeperRegistryStrategy();
        } else if ("nacos".equals(rtype)) {
            registryStrategy = new NacosRegistryStrategy();
        }
        if (registryStrategy != null) {
            RegistryConfig registry = registryStrategy.createRegistryConfig(url);
            registry.setProtocol("kregistrycenter");
            return registry;
        }
        KDRegistryConfig registry = new KDRegistryConfig();
        registry.setProtocol("kregistrycenter");
        if ("false".equals(System.getProperty("mservice.registry.register"))) {
            registry.setRegister(false);
        }
        return registry;
    }
}

