/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.rpc.dubbo.registry.strategy.zk;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.config.RegistryConfig;
import java.util.UUID;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.rpc.dubbo.DubboBeanManager;
import kd.bos.mservice.rpc.dubbo.config.KDRegistryConfig;
import kd.bos.mservice.rpc.dubbo.registry.strategy.AbstractRegistryStrategy;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ZookeeperRegistryStrategy
implements AbstractRegistryStrategy {
    private static final Log logger = LogFactory.getLog(ZookeeperRegistryStrategy.class);
    private static final String DUBBO_REGISTRY_ADDRESS = "dubbo.registry.address";
    private static final String PROTOCOL_ZOOKEEPER = "zookeeper";
    private static String dubboIdentifyPath;
    private static String identifyPath;

    @Override
    public RegistryConfig createRegistryConfig(URL url) {
        KDRegistryConfig registry = new KDRegistryConfig();
        String protocol = System.getProperty("dubbo.registry.protocol", PROTOCOL_ZOOKEEPER);
        String address = ZookeeperRegistryStrategy.getZkUrl();
        registry.setAddress(ZKFactory.getZkAddress((String)address));
        registry.setProtocol(protocol);
        if ("false".equals(System.getProperty("dubbo.registry.register"))) {
            registry.setRegister(false);
        }
        String dubboRPath = ZKFactory.getZkRootPath((String)address);
        String split = System.getProperty("dubbo.registry.clusterSplit");
        if ((split == null || "true".equals(split)) && Instance.getClusterName() != null) {
            registry.setRoot(dubboRPath + "kdubbo/" + Instance.getClusterName());
        } else {
            registry.setRoot(dubboRPath + "dubbo");
        }
        this.initZookeeperAccount(registry);
        return registry;
    }

    public void initZookeeperAccount(KDRegistryConfig registry) {
        String[] authorities;
        String atthority;
        String sysaddress = Boolean.getBoolean("ha.component.enable") ? System.getProperty("ha.zookeeper.backup") : System.getProperty(DUBBO_REGISTRY_ADDRESS);
        if (sysaddress != null && sysaddress.length() > 0 && (atthority = ZKFactory.getAuthority((String)sysaddress)) != null && atthority.indexOf(":") > 0 && (authorities = atthority.split(":")).length == 2) {
            registry.setUsername(authorities[0]);
            registry.setPassword(authorities[1]);
        }
    }

    private static String getZkUrl() {
        String protocol = System.getProperty("dubbo.registry.protocol", PROTOCOL_ZOOKEEPER);
        String address = System.getProperty(DUBBO_REGISTRY_ADDRESS);
        if (!PROTOCOL_ZOOKEEPER.equals(protocol) && !"kregistrycenter".equals(protocol) || address == null) {
            address = System.getProperty("configUrl");
        }
        if (address == null || address.trim().length() == 0) {
            throw new Error(String.format("Dubbo starting failed, %s is not configured.", DUBBO_REGISTRY_ADDRESS));
        }
        return address;
    }

    private static void createIdentifyPath() {
        try {
            CuratorFramework client = DubboBeanManager.getDubboClient();
            Stat exists = (Stat)client.checkExists().forPath(dubboIdentifyPath);
            if (exists == null) {
                ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.PERSISTENT)).forPath(dubboIdentifyPath);
            }
            ((ACLBackgroundPathAndBytesable)client.create().withMode(CreateMode.EPHEMERAL)).forPath(dubboIdentifyPath + identifyPath);
        }
        catch (Exception e) {
            logger.error("DubboBeanManager createIdentifyPath error:", (Throwable)e);
        }
    }

    static {
        identifyPath = "/" + System.getProperty("appName") + "_" + UUID.randomUUID().toString();
    }
}

