/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.statement;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.SQLStatementImpl;
import com.alibaba.druid.sql.ast.statement.SQLDropStatement;
import com.alibaba.druid.sql.ast.statement.SQLEXECIndex;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLDropIndexStatement
extends SQLStatementImpl
implements SQLDropStatement,
SQLReplaceable,
SQLEXECIndex {
    private SQLName indexName;
    private SQLExprTableSource tableName;
    private SQLExpr algorithm;
    private SQLExpr lockOption;
    private boolean ifExists;

    public SQLDropIndexStatement() {
    }

    public SQLDropIndexStatement(DbType dbType) {
        super(dbType);
    }

    @Override
    public SQLName getIndexName() {
        return this.indexName;
    }

    @Override
    public void setIndexName(SQLName indexName) {
        this.indexName = indexName;
    }

    public SQLExprTableSource getTableName() {
        return this.tableName;
    }

    public void setTableName(SQLName tableName) {
        this.setTableName(new SQLExprTableSource((SQLExpr)tableName));
    }

    public void setTableName(SQLExprTableSource tableName) {
        this.tableName = tableName;
    }

    public SQLExpr getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(SQLExpr x) {
        if (x != null) {
            x.setParent((SQLObject)this);
        }
        this.algorithm = x;
    }

    public SQLExpr getLockOption() {
        return this.lockOption;
    }

    public void setLockOption(SQLExpr x) {
        if (x != null) {
            x.setParent((SQLObject)this);
        }
        this.lockOption = x;
    }

    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild(visitor, (SQLObject)this.indexName);
            this.acceptChild(visitor, (SQLObject)this.tableName);
            this.acceptChild(visitor, (SQLObject)this.algorithm);
            this.acceptChild(visitor, (SQLObject)this.lockOption);
        }
        visitor.endVisit(this);
    }

    public List<SQLObject> getChildren() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        if (this.indexName != null) {
            children.add((SQLObject)this.indexName);
        }
        if (this.tableName != null) {
            children.add((SQLObject)this.tableName);
        }
        return children;
    }

    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.indexName == expr) {
            this.setIndexName((SQLName)target);
            return true;
        }
        if (this.algorithm == expr) {
            this.setAlgorithm(target);
            return true;
        }
        if (this.lockOption == expr) {
            this.setLockOption(target);
            return true;
        }
        return false;
    }

    public boolean isIfExists() {
        return this.ifExists;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }
}

