/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bundle.BosRes;
import kd.bos.thread.SetThreadName;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.ParallelExecuteContext;
import kd.bos.xdb.ParallelTag;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLog;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.performance.PerformanceMetric;

public class ParallelExecutor
implements XDBLogable {
    private static final ThreadFactory tf = new ThreadFactory(){
        private final ThreadGroup g = new ThreadGroup(ParallelExecutor.class.getSimpleName());

        @Override
        public Thread newThread(Runnable r) {
            return new ParallelThread(this.g, r);
        }
    };
    private static final ExecutorService es = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), tf);
    private static final ThreadLocal<Long> parallelTimestampTH = new ThreadLocal();

    public static <V> Future<V> submit(Callable<V> callable) {
        Object value;
        if (XDBConfig.get().isEnableParallelExecute()) {
            String traceId = TraceIdUtil.getCurrentTraceIdString();
            return es.submit(() -> {
                try {
                    SetThreadName.start();
                    if (StringUtils.isNotEmpty((String)traceId)) {
                        TraceIdUtil.setCurrentTraceId((String)traceId);
                    }
                    Object v = callable.call();
                    return v;
                }
                finally {
                    SetThreadName.end();
                    ThreadLocals.release();
                }
            });
        }
        try {
            value = callable.call();
        }
        catch (Throwable e) {
            value = e;
        }
        final Object ret = value;
        return new Future<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public V get() throws InterruptedException, ExecutionException {
                if (ret instanceof Throwable) {
                    throw new ExecutionException((Throwable)ret);
                }
                return ret;
            }

            @Override
            public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupParallelThreadContext(ParallelTag tag, ParallelExecuteContext pec, MetricsCollector mc) {
        if (mc.isPerformanceMetricEnabled()) {
            PerformanceMetric pm;
            PerformanceMetric performanceMetric = pm = mc.performanceMetric();
            synchronized (performanceMetric) {
                pm.setParallelQuery(pm.getParallelQuery() + 1);
            }
        }
        parallelTimestampTH.set(System.currentTimeMillis());
        if (pec != null) {
            pec.setup();
        }
    }

    public static void clearParallelThreadContext(ParallelTag tag) {
        ParallelExecuteContext pec = ExtContext.getParallelExecuteContext();
        ParallelExecutor.clearParallelThreadContext(tag, pec);
    }

    public static void clearParallelThreadContext(ParallelTag tag, ParallelExecuteContext pec) {
        if (pec != null) {
            pec.clear();
        }
        if (tag.getSqlInfo() != null) {
            String percent = tag.completeAndGetPercent();
            long ts = System.currentTimeMillis() - parallelTimestampTH.get();
            String appendMsg = Thread.currentThread() + tag.toString() + BosRes.get((String)"bos-xdb", (String)"ParallelExecutor_0", (String)"\u6267\u884c\u5b8c\u6bd5", (Object[])new Object[0]) + percent;
            XDBLog.logSharding(tag.getSqlInfo(), false, appendMsg, ts);
        }
    }

    public static class ParallelThread
    extends Thread {
        private static AtomicInteger seq = new AtomicInteger();

        public ParallelThread(ThreadGroup g, Runnable r) {
            super(g, r);
            this.setName("XDB-" + ParallelThread.class.getSimpleName() + '-' + seq.incrementAndGet());
            this.setDaemon(true);
        }
    }
}

