/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import com.microsoft.sqlserver.jdbc.SQLServerDataTable;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.ext.SelfSetParameter;
import kd.bos.xdb.sharding.KSQLTimePatternFormatter;
import kd.bos.xdb.util.InParamComparator;
import kd.bos.xdb.util.Pair;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

public abstract class ParameterSetter {
    private static final Map<Class<?>, ParameterSetter> setterCache = new ConcurrentHashMap();
    private static final SelfSetParameterSetter selfSetter = new SelfSetParameterSetter();
    private static final ObjectSetter objectSetter = new ObjectSetter();
    private static final BytesSetter bytesSetter = new BytesSetter();
    private static final ArraySetter arraySetter = new ArraySetter();
    private static final StringSetter stringSetter = new StringSetter();
    private static final BigDecimalSetter bigDecimalSetter = new BigDecimalSetter();
    private static final DateSetter dateSetter = new DateSetter();
    private static final TimestampSetter timestampSetter = new TimestampSetter();
    private static final BooleanSetter booleanSetter = new BooleanSetter();

    protected abstract void doSet(PreparedStatement var1, Object var2, int var3, int var4) throws SQLException;

    public static void set(PreparedStatement stmt, Object value, int index) throws SQLException {
        ParameterSetter.getSetter(value == null ? Object.class : value.getClass()).doSet(stmt, value, index, 1111);
    }

    public static void set(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
        ParameterSetter.getSetter(value == null ? Object.class : value.getClass()).doSet(stmt, value, index, sqlType);
    }

    public static void fillBatch(boolean expand, PreparedStatement ps, List<Object[]> paramsList) throws SQLException {
        new BatchSetter(expand, ps).fill(paramsList);
    }

    public static void fill(boolean expand, PreparedStatement ps, Object ... params) throws SQLException {
        block6: {
            if (params == null || params.length <= 0) break block6;
            int i = 1;
            if (expand) {
                for (Object obj : params) {
                    if (obj == null) {
                        ps.setObject(i++, null);
                        continue;
                    }
                    i = ParameterSetter.setExpand(ps, obj, i, null).getKey();
                }
            } else {
                for (Object obj : params) {
                    if (obj == null) {
                        ps.setObject(i++, null);
                        continue;
                    }
                    ParameterSetter.set(ps, obj, i++);
                }
            }
        }
    }

    private static Pair<Integer, ParameterSetter> setExpand(PreparedStatement ps, Object obj, int i, ParameterSetter setter) throws SQLException {
        Class<?> cls = obj.getClass();
        if (cls.isArray() && cls != byte[].class) {
            int n = Array.getLength(obj);
            for (int j = 0; j < n; ++j) {
                Object value = Array.get(obj, j);
                if (value == null) {
                    ps.setObject(i++, null);
                    continue;
                }
                if (setter == null) {
                    setter = ParameterSetter.getSetter(value.getClass());
                }
                setter.doSet(ps, value, i++, 1111);
            }
        } else if (Iterable.class.isAssignableFrom(cls)) {
            for (Object value : (Iterable)obj) {
                if (value == null) {
                    ps.setObject(i++, null);
                    continue;
                }
                if (setter == null) {
                    setter = ParameterSetter.getSetter(value.getClass());
                }
                setter.doSet(ps, value, i++, 1111);
            }
        } else {
            if (setter == null) {
                setter = ParameterSetter.getSetter(cls);
            }
            setter.doSet(ps, obj, i++, 1111);
        }
        return new Pair<Integer, ParameterSetter>(i, setter);
    }

    private static ParameterSetter getSetter(Class<?> p) {
        if (p == Long.class || p == Integer.class || p == Long.TYPE || p == Integer.TYPE || p == Object.class) {
            return objectSetter;
        }
        if (p == String.class || p == Character.class || p == Character.TYPE || Enum.class.isAssignableFrom(p)) {
            return stringSetter;
        }
        if (p == BigDecimal.class) {
            return bigDecimalSetter;
        }
        if (p == Boolean.class || p == Boolean.TYPE) {
            return booleanSetter;
        }
        if (p == Timestamp.class) {
            return timestampSetter;
        }
        if (java.util.Date.class.isAssignableFrom(p)) {
            return dateSetter;
        }
        if (SelfSetParameter.class.isAssignableFrom(p)) {
            return selfSetter;
        }
        if (p == byte[].class || p == Byte[].class) {
            return bytesSetter;
        }
        if (p.isArray() || Iterable.class.isAssignableFrom(p)) {
            return arraySetter;
        }
        ParameterSetter ps = setterCache.get(p);
        if (ps == null) {
            for (Class<?> pcls = p.getSuperclass(); pcls != null; pcls = pcls.getSuperclass()) {
                ps = setterCache.get(pcls);
                if (ps == null) continue;
                setterCache.put(pcls, ps);
                setterCache.put(p, ps);
                break;
            }
            if (ps == null) {
                ps = objectSetter;
                setterCache.put(p.getClass(), ps);
            }
        }
        return ps;
    }

    public static DBType getDBType(Connection con) throws SQLException {
        String dbType = con.getMetaData().getDatabaseProductName().toLowerCase();
        if (dbType.indexOf("postgresql") != -1) {
            return DBType.postgresql;
        }
        if (dbType.indexOf("mysql") != -1 || dbType.indexOf("mariadb") != -1) {
            return DBType.mysql;
        }
        if (dbType.indexOf("oracle") != -1) {
            return DBType.oracle;
        }
        if (dbType.indexOf("sqlserver") != -1 || dbType.indexOf("microsoft") != -1) {
            return DBType.sqlserver;
        }
        if (dbType.indexOf("dm") != -1) {
            return DBType.dm;
        }
        if (dbType.indexOf("gs") != -1) {
            return DBType.gs;
        }
        if (dbType.indexOf("oceanbase_oracle") != -1) {
            return DBType.oceanbase_oracle;
        }
        if (dbType.indexOf("gs100") != -1 || dbType.indexOf("zenith") != -1) {
            return DBType.gs100;
        }
        if (dbType.indexOf("hdb") != -1 || dbType.indexOf("hana") != -1) {
            return DBType.hana;
        }
        if (dbType.indexOf("clickhouse") != -1) {
            return DBType.clickhouse;
        }
        throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"ParameterSetter_0", (String)"\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b:{0}\u3002", (Object[])new Object[]{dbType}));
    }

    static {
        ByteSetter byteSetter = new ByteSetter();
        setterCache.put(Byte.class, byteSetter);
        setterCache.put(Byte.TYPE, byteSetter);
        setterCache.put(java.util.Date.class, dateSetter);
        setterCache.put(Date.class, dateSetter);
        setterCache.put(Timestamp.class, timestampSetter);
        setterCache.put(Boolean.class, booleanSetter);
        setterCache.put(Boolean.TYPE, booleanSetter);
        DoubleSetter doubleSetter = new DoubleSetter();
        setterCache.put(Double.class, doubleSetter);
        setterCache.put(Double.TYPE, doubleSetter);
        FloatSetter floatSetter = new FloatSetter();
        setterCache.put(Float.class, floatSetter);
        setterCache.put(Float.TYPE, floatSetter);
        ShortSetter shortSetter = new ShortSetter();
        setterCache.put(Short.class, shortSetter);
        setterCache.put(Short.TYPE, shortSetter);
        setterCache.put(Object.class, objectSetter);
        setterCache.put(Integer.class, objectSetter);
        setterCache.put(Integer.TYPE, objectSetter);
        setterCache.put(Long.class, objectSetter);
        setterCache.put(Long.TYPE, objectSetter);
        setterCache.put(Character.TYPE, stringSetter);
        setterCache.put(Character.class, stringSetter);
        setterCache.put(String.class, stringSetter);
        setterCache.put(Enum.class, stringSetter);
        setterCache.put(BigDecimal.class, bigDecimalSetter);
        setterCache.put(BigInteger.class, new BigIntegerSetter());
    }

    public static final class BatchSetter {
        private final boolean expand;
        private final PreparedStatement ps;
        private ParameterSetter[] setterCache;
        private int N = -1;
        private int row = 0;

        public BatchSetter(boolean expand, PreparedStatement ps) {
            this.expand = expand;
            this.ps = ps;
        }

        public void fill(Object[] params) throws SQLException {
            if (this.expand) {
                this.setExpand(params);
            } else {
                this.set(params);
            }
        }

        public void fill(List<Object[]> paramsList) throws SQLException {
            if (this.expand) {
                for (Object[] params : paramsList) {
                    this.setExpand(params);
                }
            } else {
                for (Object[] params : paramsList) {
                    this.set(params);
                }
            }
        }

        private void set(Object[] params) throws SQLException {
            ++this.row;
            if (this.setterCache == null) {
                this.N = params.length;
                this.setterCache = new ParameterSetter[this.N];
            } else if (this.N != params.length) {
                throw new SQLException("Parameter incorrect @row" + this.row + ", expert length=" + this.N + " actual=" + params.length + ": " + Arrays.deepToString(params));
            }
            for (int i = 0; i < this.N; ++i) {
                Object value = params[i];
                if (value == null) {
                    this.ps.setNull(i + 1, 0);
                    continue;
                }
                ParameterSetter setter = this.setterCache[i];
                if (setter == null) {
                    setter = this.setterCache[i] = ParameterSetter.getSetter(value.getClass());
                }
                setter.doSet(this.ps, value, i + 1, 1111);
            }
            this.ps.addBatch();
        }

        private void setExpand(Object[] params) throws SQLException {
            ++this.row;
            if (this.setterCache == null) {
                HashMap setterMap = new HashMap(params.length);
                int i = 1;
                for (Object value : params) {
                    if (value == null) {
                        this.ps.setNull(i++, 0);
                        continue;
                    }
                    Pair setPair = ParameterSetter.setExpand(this.ps, value, i, null);
                    setterMap.put(i - 1, setPair.getValue());
                    i = (Integer)setPair.getKey();
                }
                this.N = i - 1;
                this.setterCache = new ParameterSetter[this.N];
                for (i = 0; i < this.N; ++i) {
                    this.setterCache[i] = (ParameterSetter)setterMap.get(i);
                }
            } else {
                int i = 1;
                for (Object value : params) {
                    if (value == null) {
                        this.ps.setNull(i++, 0);
                        continue;
                    }
                    ParameterSetter setter = this.setterCache[i - 1];
                    Pair setPair = ParameterSetter.setExpand(this.ps, value, i, setter);
                    if (setter == null) {
                        this.setterCache[i - 1] = (ParameterSetter)setPair.getValue();
                    }
                    i = (Integer)setPair.getKey();
                }
                if (this.N != i - 1) {
                    throw new SQLException("Parameter incorrect @row" + this.row + ", expert length=" + this.N + " actual=" + (i - 1) + ": " + Arrays.deepToString(params));
                }
            }
            this.ps.addBatch();
        }
    }

    static class ArraySetter
    extends ParameterSetter {
        ArraySetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            int c;
            if (value == null) {
                stmt.setObject(index, null);
                return;
            }
            Class<?> type = null;
            Object[] params = null;
            if (value.getClass().isArray()) {
                type = value.getClass().getComponentType();
                if (type == Object.class) {
                    params = (Object[])value;
                } else {
                    c = Array.getLength(value);
                    params = new Object[c];
                    for (int i = 0; i < c; ++i) {
                        params[i] = Array.get(value, i);
                    }
                }
            } else if (value instanceof Iterable) {
                if (value instanceof Collection) {
                    params = ((Collection)value).toArray();
                } else {
                    c = 0;
                    LinkedList list = new LinkedList();
                    Iterator iter = ((Iterable)value).iterator();
                    while (iter.hasNext()) {
                        list.add(iter.next());
                        ++c;
                    }
                    params = new Object[c];
                    list.toArray(params);
                }
            } else {
                params = new Object[]{value};
            }
            Connection con = stmt.getConnection();
            DBType dbType = ArraySetter.getDBType(con);
            if (dbType == DBType.mysql) {
                StringBuilder sb = new StringBuilder(params.length * 19);
                for (Object p : params) {
                    sb.append(p);
                    sb.append(',');
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
                stmt.setObject(index, sb.toString());
            } else {
                OracleConnection ocon;
                String typeName = null;
                if (sqlType != 1111) {
                    if (sqlType == -5 || sqlType == 4 || sqlType == 5 || sqlType == -6) {
                        typeName = "UDT_INTTABLE";
                    } else if (sqlType == 12) {
                        typeName = "UDT_VARCHARTABLE";
                    } else if (sqlType == -9) {
                        typeName = "UDT_NVARCHARTABLE";
                    }
                }
                if (typeName == null) {
                    if (type == null || type == Object.class) {
                        for (Object v : params) {
                            if (v == null) continue;
                            type = v.getClass();
                            break;
                        }
                    }
                    typeName = "UDT_NVARCHARTABLE";
                    if (type != null && (Number.class.isAssignableFrom(type) || type == Integer.TYPE || type == Long.TYPE)) {
                        typeName = "UDT_INTTABLE";
                    }
                }
                InParamComparator.trySort(params);
                if (dbType == DBType.oracle) {
                    ocon = con.unwrap(OracleConnection.class);
                    ArrayDescriptor des = ArrayDescriptor.createDescriptor((String)typeName, (Connection)ocon);
                    stmt.unwrap(OraclePreparedStatement.class).setARRAY(index, new ARRAY(des, (Connection)ocon, (Object)params));
                } else if (dbType == DBType.dm) {
                    ocon = con.unwrap(DmdbConnection.class);
                    dm.jdbc.desc.ArrayDescriptor des = new dm.jdbc.desc.ArrayDescriptor(typeName, (DmdbConnection)ocon);
                    stmt.unwrap(DmdbPreparedStatement.class).setArray(index, (java.sql.Array)new DmdbArray(des, (DmdbConnection)ocon, params));
                } else if (dbType == DBType.postgresql) {
                    stmt.setObject(index, value, 2003);
                } else if (dbType == DBType.sqlserver) {
                    SQLServerDataTable dataTable = new SQLServerDataTable();
                    dataTable.setTvpName(typeName);
                    dataTable.addColumnMetadata("fid", sqlType);
                    for (Object val : params) {
                        dataTable.addRow(new Object[]{val});
                    }
                    stmt.unwrap(SQLServerPreparedStatement.class).setObject(index, (Object)dataTable);
                } else {
                    java.sql.Array array = stmt.getConnection().createArrayOf(typeName, params);
                    stmt.setArray(index, array);
                }
            }
        }
    }

    static class ObjectSetter
    extends ParameterSetter {
        ObjectSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setObject(index, value);
        }
    }

    static class BytesSetter
    extends ParameterSetter {
        BytesSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            if (value.getClass() == Byte[].class) {
                int len = ((Byte[])value).length;
                byte[] bytes = new byte[len];
                for (int i = 0; i < len; ++i) {
                    bytes[i] = ((Byte[])value)[i];
                }
                stmt.setBytes(index, bytes);
            } else {
                stmt.setBytes(index, (byte[])value);
            }
        }
    }

    static class ByteSetter
    extends ParameterSetter {
        ByteSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setByte(index, (Byte)value);
        }
    }

    static class TimestampSetter
    extends ParameterSetter {
        TimestampSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setTimestamp(index, (Timestamp)value);
        }
    }

    static class DateSetter
    extends ParameterSetter {
        DateSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setTimestamp(index, new Timestamp(((java.util.Date)value).getTime()));
        }
    }

    static class FloatSetter
    extends ParameterSetter {
        FloatSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setFloat(index, ((Float)value).floatValue());
        }
    }

    static class DoubleSetter
    extends ParameterSetter {
        DoubleSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setDouble(index, (Double)value);
        }
    }

    static class BigDecimalSetter
    extends ParameterSetter {
        BigDecimalSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setBigDecimal(index, (BigDecimal)value);
        }
    }

    static class BigIntegerSetter
    extends ParameterSetter {
        BigIntegerSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setLong(index, ((BigInteger)value).longValue());
        }
    }

    static class StringSetter
    extends ParameterSetter {
        StringSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            String s;
            String string = s = value == null ? null : String.valueOf(value);
            if (value != null && s.length() == 0 && XDBConfig.get().isSpaceAsEmptyString()) {
                s = " ";
            }
            if (XDBConfig.isParamWithKSQLTimePattern()) {
                if (value != null && s.length() > 0) {
                    KSQLTimePatternFormatter ksqlTimePatternFormatter = new KSQLTimePatternFormatter(s);
                    if (ksqlTimePatternFormatter.isKSQLTimePattern()) {
                        value = ksqlTimePatternFormatter.getKSQLTimePatternToDate();
                        dateSetter.doSet(stmt, value, index, sqlType);
                    } else {
                        stmt.setString(index, s);
                    }
                }
            } else {
                stmt.setString(index, s);
            }
        }
    }

    static class IntSetter
    extends ParameterSetter {
        IntSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setInt(index, (Integer)value);
        }
    }

    static class ShortSetter
    extends ParameterSetter {
        ShortSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            stmt.setShort(index, (Short)value);
        }
    }

    static class BooleanSetter
    extends ParameterSetter {
        BooleanSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            String s = value instanceof Boolean ? ((Boolean)value != false ? "1" : "0") : "0";
            stmt.setString(index, s);
        }
    }

    static class SelfSetParameterSetter
    extends ParameterSetter {
        SelfSetParameterSetter() {
        }

        @Override
        protected void doSet(PreparedStatement stmt, Object value, int index, int sqlType) throws SQLException {
            ((SelfSetParameter)value).setValue(stmt, index);
        }
    }
}

