/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import kd.bos.util.ThreadLocals;
import kd.bos.xdb.QueryTimeout;
import kd.bos.xdb.XDBConfig;

public class QueryTimeoutImpl
implements QueryTimeout {
    private int seconds;
    private QueryTimeout parent;
    private static ThreadLocal<QueryTimeout> thTimeout = ThreadLocals.create();

    private QueryTimeoutImpl(int seconds, QueryTimeout parent) {
        this.seconds = seconds;
        this.parent = parent;
    }

    @Override
    public void close() {
        if (this.parent != null) {
            thTimeout.set(this.parent);
        } else {
            thTimeout.remove();
        }
    }

    @Override
    public int getSeconds() {
        return this.seconds;
    }

    static QueryTimeout timeout(int seconds) {
        QueryTimeoutImpl to = new QueryTimeoutImpl(seconds, thTimeout.get());
        thTimeout.set(to);
        return to;
    }

    public static QueryTimeout getTimeout() {
        return thTimeout.get();
    }

    public static int getQueryTimeoutSeconds() {
        int webRequestTimeout = XDBConfig.handleWebRequestTimeout();
        int queryTimeout = QueryTimeoutImpl.getTimeout() != null ? QueryTimeoutImpl.getTimeout().getSeconds() : XDBConfig.get().getQueryTimeoutSeconds();
        return Math.min(webRequestTimeout, queryTimeout);
    }
}

