/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.KSQLIfExistsStatement;
import com.alibaba.druid.sql.ast.statement.SQLDDLStatement;
import com.alibaba.druid.sql.ast.statement.SQLEXECStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bundle.BosRes;
import kd.bos.exception.XDBErrorCode;
import kd.bos.thread.ShardingStats;
import kd.bos.util.StringUtils;
import kd.bos.xdb.AutoCloseSet;
import kd.bos.xdb.ExceedShardingQueryLimit;
import kd.bos.xdb.ParallelExecuteContext;
import kd.bos.xdb.ParallelExecutor;
import kd.bos.xdb.ParallelTag;
import kd.bos.xdb.ParameterSetter;
import kd.bos.xdb.QueryTimeout;
import kd.bos.xdb.QueryTimeoutImpl;
import kd.bos.xdb.XDB;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBExternal;
import kd.bos.xdb.XDBLog;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.XDBManageContext;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.engine.ShardingEngine;
import kd.bos.xdb.engine.ShardingEngineFactory;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.exception.LimitedSQLException;
import kd.bos.xdb.exception.XdbException;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.ext.KSQLTransfer;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.jdbc.connection.XDBConnection;
import kd.bos.xdb.jdbc.statement.XDBPrepareStatement;
import kd.bos.xdb.jdbc.statement.XDBStatement;
import kd.bos.xdb.merge.MergeManager;
import kd.bos.xdb.merge.ResultSetFactory;
import kd.bos.xdb.merge.resultset.fetched.FetchedResultSet;
import kd.bos.xdb.mergeengine.ExecutionContext;
import kd.bos.xdb.mergeengine.MergeEngineFactory;
import kd.bos.xdb.parameter.ParameterFillerFactory;
import kd.bos.xdb.parameter.batch.AbstractBatchFiller;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.temptable.facade.TemptableFacadeContext;
import kd.bos.xdb.temptable.facade.TemptableFacadeContexts;
import kd.bos.xdb.temptable.manager.TemptableFacadeResolver;
import kd.bos.xdb.temptable.manager.TemptableManager;
import kd.bos.xdb.util.ArrayUtil;
import kd.bos.xdb.util.Pair;
import kd.bos.xdb.xpm.exporter.ExporterService;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.collector.StatTimeStamp;

public class XDBExecutor
implements XDB,
XDBLogable {
    private static final ThreadLocal<LinkedList<XDBManageContext>> manageContextListTH = new ThreadLocal();
    private static final XDBConfig config = XDBConfig.get();
    private static final ShardingEngine engine = ShardingEngineFactory.get();
    static final XDBExecutor instance = new XDBExecutor();

    protected XDBExecutor() {
        ExporterService.start();
    }

    @Override
    public boolean isSharding(String tableName) {
        return XDBConfig.isXDBEnabled() && XDBConfig.getShardingConfigProvider().getConfig(tableName) != null;
    }

    @Override
    public List<SQLInfo> extractSQLs(String sql, Object ... params) throws SQLException {
        sql = this.trans(sql);
        ShardingResult sr = engine.sharding(sql, params);
        ArrayList<SQLInfo> ret = new ArrayList<SQLInfo>(4);
        if (sr.withUnion()) {
            do {
                ret.addAll(Arrays.asList(sr.getSQLInfos()));
            } while ((sr = sr.getUnionShardingResult()) != null);
        } else {
            ret.addAll(Arrays.asList(sr.getSQLInfos()));
        }
        for (SQLInfo si : ret) {
            si.setSql(this.markDialectSQL(si.getSql()));
        }
        return ret;
    }

    private boolean isPermittedMultiWrited(ShardingResult ... srs) {
        StatementInfo statementInfo = srs[0].getStatementInfo();
        if (statementInfo != null) {
            SQLStatement sqlStatement;
            SQLStatement stmt;
            List<SQLStatement> sqlStatementList;
            if (statementInfo.getStatementType().isDDL() || statementInfo.getStatementType() == StatementType.exec || statementInfo.getStatementType() == StatementType.truncate) {
                return true;
            }
            if (statementInfo.getStatementType() == StatementType.if_exists && !(sqlStatementList = ((KSQLIfExistsStatement)(stmt = statementInfo.getSQLStatement())).getStatements()).isEmpty() && ((sqlStatement = sqlStatementList.get(0)) instanceof SQLDDLStatement || sqlStatement instanceof SQLEXECStatement)) {
                return true;
            }
        }
        return false;
    }

    private String checkMultiDBRouteWrited(ShardingResult ... srs) {
        HashSet<String> routes = new HashSet<String>();
        for (ShardingResult sr : srs) {
            if (sr.getSQLInfos().length <= 0) continue;
            for (SQLInfo sqlInfo : sr.getSQLInfos()) {
                if (StringUtils.isNotEmpty((String)sqlInfo.getDbRoute())) {
                    routes.add(sqlInfo.getDbRoute());
                    continue;
                }
                routes.add(ExtContext.get().getDBRoute());
            }
        }
        if (routes.size() > 1) {
            StringBuilder msg = new StringBuilder(1024);
            msg.append("Can not write more than one database: ").append(String.join((CharSequence)",", routes));
            msg.append("\r\n[write-sql]\r\n");
            StringBuilder sql = new StringBuilder(10240);
            block2: for (ShardingResult sr : srs) {
                for (SQLInfo sqlInfo : sr.getSQLInfos()) {
                    sql.append(sqlInfo.getDbRoute()).append(":").append(sqlInfo.getSql()).append("\r\n");
                    if (sql.length() >= 10240) continue block2;
                }
            }
            msg.append(sql.length() <= 10240 ? sql : sql.substring(0, 10240) + "...");
            throw new LimitedSQLException(XDBErrorCode.xdbMultiDBWrited, msg.toString());
        }
        return (String)routes.iterator().next();
    }

    private void checkExpectedActualRoute(SQLInfo si, String curRoute) {
        if (si.isShardingSQL() && !si.getDbRoute().equalsIgnoreCase(curRoute)) {
            StringBuilder msg = new StringBuilder(1024);
            msg.append("The expected route is: [").append(si.getDbRoute()).append("], but the actual route is: [").append(curRoute).append("].");
            msg.append("\r\nsql:\r\n");
            msg.append(si.getSql().length() <= 10240 ? si.getSql() : si.getSql().substring(0, 10240) + "...");
            throw new LimitedSQLException(XDBErrorCode.xdbRouteInconsistency, msg.toString());
        }
    }

    private TemptableFacadeResolver getTemptableFacadeResolver() {
        TemptableFacadeContext context = TemptableFacadeContexts.get();
        if (context == null || context.isTableListEmpty()) {
            return null;
        }
        return new TemptableFacadeResolver(context, TemptableManager.get());
    }

    private String handleTemptableSingle(String routeKey, TemptableFacadeResolver facadeResolver, String sql) {
        if (facadeResolver == null) {
            return sql;
        }
        return facadeResolver.resolve(routeKey, sql);
    }

    private void handleTemptableForUpdate(String dbRoute, TemptableFacadeResolver facadeResolver, ShardingResult ... srs) {
        if (facadeResolver == null) {
            return;
        }
        for (ShardingResult sr : srs) {
            for (SQLInfo sqlInfo : sr.getSQLInfos()) {
                String newSql = facadeResolver.resolve(dbRoute, sqlInfo.getSql());
                sqlInfo.setSql(newSql);
            }
        }
    }

    private void handleTemptableForQuery(ShardingResult sr) {
        TemptableFacadeContext context = TemptableFacadeContexts.get();
        if (context == null || context.isTableListEmpty()) {
            return;
        }
        TemptableFacadeResolver resolver = new TemptableFacadeResolver(context, TemptableManager.get());
        for (SQLInfo sqlInfo : sr.getSQLInfos()) {
            String newSql = resolver.resolve(sqlInfo.getDbRoute(), sqlInfo.getSql());
            sqlInfo.setSql(newSql);
        }
    }

    @Override
    public ResultSet query(String sql, Object ... params) throws SQLException {
        MetricsCollector mc = MetricsCollector.getCurrent();
        String originalSQL = sql;
        ShardingResult sr = engine.sharding(sql = this.trans(sql), params);
        if (sr.getStatementInfo() != null && sr.getStatementInfo().getStatementType() != StatementType.select) {
            throw new XdbException("Query non select statement: " + sql);
        }
        boolean writtenInTX = ExtContext.writtenInTX(sql);
        this.handleTemptableForQuery(sr);
        if (XDBConfig.isMergeStableEnable()) {
            return this.doStableQuery(sr, originalSQL);
        }
        AutoCloseSet autoCloseSet = new AutoCloseSet();
        int queryTimeoutSeconds = QueryTimeoutImpl.getQueryTimeoutSeconds();
        if (sr.withUnion()) {
            ArrayList<Pair<ShardingResult, ResultSet>> rss = new ArrayList<Pair<ShardingResult, ResultSet>>();
            ArrayList<Future<Pair>> listFS = new ArrayList<Future<Pair>>(2);
            ShardingResult unionSR = sr;
            int roundCount = 0;
            while (unionSR != null) {
                unionSR = unionSR.getUnionShardingResult();
                ++roundCount;
            }
            int round = 0;
            AtomicInteger completedCount = new AtomicInteger();
            Semaphore sp = new Semaphore(config.getSingleParallelSize());
            for (unionSR = sr; unionSR != null; unionSR = unionSR.getUnionShardingResult()) {
                ParallelExecuteContext pec = ExtContext.getParallelExecuteContext();
                ShardingResult shardingResult = unionSR;
                ParallelTag tag = new ParallelTag(autoCloseSet.parallelId(), ++round, roundCount, completedCount);
                try {
                    sp.acquire();
                }
                catch (InterruptedException e) {
                    throw this.logAndConvertException(e);
                }
                Future<Pair> f = ParallelExecutor.submit(() -> {
                    if (config.isEnableParallelExecute()) {
                        ParallelExecutor.setupParallelThreadContext(tag, pec, mc);
                    }
                    try {
                        ResultSet rs = this.doQuery(cur, originalSQL, engine, autoCloseSet, queryTimeoutSeconds, tag, mc, writtenInTX);
                        Pair<ShardingResult, ResultSet> pair = new Pair<ShardingResult, ResultSet>(cur, rs);
                        return pair;
                    }
                    finally {
                        sp.release();
                        if (config.isEnableParallelExecute()) {
                            ParallelExecutor.clearParallelThreadContext(tag);
                        }
                    }
                });
                listFS.add(f);
            }
            try {
                for (Future future : listFS) {
                    rss.add((Pair<ShardingResult, ResultSet>)future.get());
                }
            }
            catch (Exception e) {
                throw this.logAndConvertException(e);
            }
            mc.sqlFeature().setSelectFeature(sr.getUnionRootSelectFeature());
            return MergeManager.union(engine.getShardingConfigProvider(), sr.getStatementInfo(), rss, sr.getParentStmt(), sr.getSelectFeature(), sr.getUnionRootSelectFeature(), mc);
        }
        return this.doQuery(sr, originalSQL, engine, autoCloseSet, queryTimeoutSeconds, null, mc, writtenInTX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet doQuery(ShardingResult sr, String originalSQL, ShardingEngine engine, AutoCloseSet autoCloseSet, int queryTimeoutSeconds, ParallelTag parentTag, MetricsCollector mc, boolean writtenInTX) throws SQLException {
        ArrayList<ResultSet> rsList;
        block28: {
            SQLInfo[] sqlInfos = sr.getSQLInfos();
            int roundCount = sqlInfos.length;
            rsList = new ArrayList<ResultSet>(roundCount);
            boolean forManager = this.isForManager();
            try {
                if (roundCount == 1 || forManager) {
                    for (SQLInfo si : sqlInfos) {
                        XDBLog.logSharding(si, forManager, null);
                        Connection con = null;
                        try {
                            Throwable throwable = null;
                            try (StatTimeStamp ss = mc.collectExecuteSpent();){
                                con = XDBConnection.get().requireConnection(parentTag, this.isForManager(), autoCloseSet, writtenInTX, originalSQL);
                                PreparedStatement ps = XDBPrepareStatement.get().prepareStatement(autoCloseSet, con, si.getSql(), queryTimeoutSeconds, mc);
                                if (XDBConfig.paramUseOpenGaussFiller()) {
                                    ParameterFillerFactory.get(ConnectionProvider.get().getConnectionHolder().getDBType()).fill(si.isShardingSQL(), ps, si.getParams());
                                } else {
                                    ParameterSetter.fill(si.isShardingSQL(), ps, si.getParams());
                                }
                                ResultSet rs = ResultSetFactory.get(ps, null);
                                if (si.isShardingSQL()) {
                                    rs = FetchedResultSet.fetch(rs, config.getFetchSize());
                                }
                                rsList.add(rs);
                            }
                            catch (Throwable throwable2) {
                                Throwable throwable3 = throwable2;
                                throw throwable2;
                            }
                            if (con == null) continue;
                            XDBConnection.get().releaseConnectionForQuery(con);
                        }
                        catch (Throwable throwable) {
                            if (con != null) {
                                XDBConnection.get().releaseConnectionForQuery(con);
                            }
                            throw throwable;
                        }
                    }
                    break block28;
                }
                if (ExceedShardingQueryLimit.get() != null && !ExceedShardingQueryLimit.get().isSkipExceedLimit() && roundCount > config.getExceedShardingtableQueryLimit()) {
                    throw new LimitedSQLException(XDBErrorCode.exceedShardingTableQueryLimit, BosRes.get((String)"bos-xdb", (String)"XDBExecutor_1", (String)"\u67e5\u8be2\u5206\u7247\u6570\u91cf\u8fc7\u8f7d\uff0c\u8bf7\u7f29\u5c0f\u8303\u56f4\u8fdb\u884c\u67e5\u8be2\uff0c\u539f\u59cbSQL:{0}\uff0c\u5206\u7247\u6570\u91cf:{1}\u3002", (Object[])new Object[]{originalSQL, roundCount}));
                }
                ArrayList<Future<ResultSet>> listFS = new ArrayList<Future<ResultSet>>(roundCount);
                int round = 0;
                AtomicInteger completedCount = new AtomicInteger();
                ParallelExecuteContext pec = ExtContext.getParallelExecuteContext();
                Semaphore sp = new Semaphore(config.getSingleParallelSize());
                for (SQLInfo si : sqlInfos) {
                    ParallelTag tag = new ParallelTag(autoCloseSet.parallelId(), ++round, roundCount, completedCount);
                    tag.setSqlInfo(si);
                    try {
                        sp.acquire();
                        XDBConnection.getGlobalParallelSizeSemaphore().acquire();
                    }
                    catch (InterruptedException e) {
                        throw this.logAndConvertException(e);
                    }
                    Future<ResultSet> f = ParallelExecutor.submit(() -> {
                        ResultSet resultSet;
                        Throwable throwable;
                        StatTimeStamp ss;
                        Connection con;
                        block22: {
                            if (config.isEnableParallelExecute()) {
                                ParallelExecutor.setupParallelThreadContext(tag, pec, mc);
                            }
                            ShardingStats shardingSql = ShardingStats.create();
                            shardingSql.setOriginalSQL(originalSQL);
                            shardingSql.setShardingCount(roundCount);
                            con = null;
                            ss = mc.collectExecuteSpentSync();
                            throwable = null;
                            con = XDBConnection.get().requireConnection(tag, this.isForManager(), autoCloseSet, writtenInTX, originalSQL);
                            PreparedStatement ps = XDBPrepareStatement.get().prepareStatement(autoCloseSet, con, si.getSql(), queryTimeoutSeconds, mc);
                            if (XDBConfig.paramUseOpenGaussFiller()) {
                                ParameterFillerFactory.get(ConnectionProvider.get().getConnectionHolder().getDBType()).fill(si.isShardingSQL(), ps, si.getParams());
                            } else {
                                ParameterSetter.fill(si.isShardingSQL(), ps, si.getParams());
                            }
                            ResultSet rs = ResultSetFactory.get(ps, null);
                            if (si.isShardingSQL()) {
                                rs = FetchedResultSet.fetch(rs, config.getFetchSize());
                            }
                            resultSet = rs;
                            if (con != null) {
                                XDBConnection.get().releaseConnectionForQuery(con);
                            }
                            XDBConnection.getGlobalParallelSizeSemaphore().release();
                            sp.release();
                            if (!config.isEnableParallelExecute()) break block22;
                            ParallelExecutor.clearParallelThreadContext(tag);
                        }
                        return resultSet;
                        {
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (ss != null) {
                                    if (throwable != null) {
                                        try {
                                            ss.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        ss.close();
                                    }
                                }
                            }
                            {
                                catch (Throwable throwable4) {
                                    if (con != null) {
                                        XDBConnection.get().releaseConnectionForQuery(con);
                                    }
                                    XDBConnection.getGlobalParallelSizeSemaphore().release();
                                    sp.release();
                                    if (config.isEnableParallelExecute()) {
                                        ParallelExecutor.clearParallelThreadContext(tag);
                                    }
                                    throw throwable4;
                                }
                            }
                        }
                    });
                    listFS.add(f);
                }
                for (Future future : listFS) {
                    rsList.add((ResultSet)future.get());
                }
            }
            catch (Exception e) {
                this.close(autoCloseSet, true);
                throw this.logAndConvertException(e);
            }
        }
        return MergeManager.merge(engine.getShardingConfigProvider(), sr.getStatementInfo(), () -> this.close(autoCloseSet, false), rsList.toArray(new ResultSet[rsList.size()]), sr.getSelectFeature(), mc);
    }

    private ResultSet doStableQuery(ShardingResult sr, String originalSQL) throws SQLException {
        return MergeEngineFactory.get(sr).merge(this.createExecutionContext(sr, originalSQL));
    }

    private ExecutionContext createExecutionContext(ShardingResult sr, String originalSQL) throws SQLException {
        return new ExecutionContext(sr, originalSQL, this.isForManager(), this.forManagerRoute(), ExtContext.writtenInTX(this.trans(originalSQL)), QueryTimeoutImpl.getQueryTimeoutSeconds());
    }

    @Override
    public int update(String sql, Object ... params) throws SQLException {
        AutoCloseSet autoCloseSet = new AutoCloseSet();
        boolean rollback = false;
        int c = 0;
        try {
            SQLInfo[] sqlInfos;
            sql = this.trans(sql);
            ShardingResult sr = engine.sharding(sql, params);
            boolean isPermittedMultiWrited = this.isPermittedMultiWrited(sr);
            if (!isPermittedMultiWrited) {
                this.checkMultiDBRouteWrited(sr);
            }
            int queryTimeoutSeconds = QueryTimeoutImpl.getQueryTimeoutSeconds();
            MetricsCollector mc = MetricsCollector.getCurrent();
            String mainRoute = ExtContext.get().getDBRoute();
            String curRoute = isPermittedMultiWrited ? mainRoute : this.getCurrentRoute(sr);
            TemptableFacadeResolver resolver = this.getTemptableFacadeResolver();
            this.handleTemptableForUpdate(curRoute, resolver, sr);
            for (SQLInfo si : sqlInfos = sr.getSQLInfos()) {
                this.checkExpectedActualRoute(si, curRoute);
                XDBLog.logSharding(si, this.isForManager());
                try (StatTimeStamp ss = mc.collectExecuteSpent();
                     PreparedStatement ps = XDBPrepareStatement.get().prepareStatement(autoCloseSet, XDBConnection.get().requireConnection(autoCloseSet, this.isForManager(), mainRoute, curRoute), si.getSql(), queryTimeoutSeconds, mc);){
                    if (XDBConfig.paramUseOpenGaussFiller()) {
                        ParameterFillerFactory.get(ConnectionProvider.get().getConnectionHolder().getDBType()).fill(si.isShardingSQL(), ps, si.getParams());
                    } else {
                        ParameterSetter.fill(si.isShardingSQL(), ps, si.getParams());
                    }
                    c += ps.executeUpdate();
                }
            }
        }
        catch (Exception e) {
            rollback = true;
            throw this.logAndConvertException(e);
        }
        finally {
            this.close(autoCloseSet, rollback);
        }
        return c;
    }

    @Override
    public boolean execute(String sql, Object ... params) throws SQLException {
        AutoCloseSet autoCloseSet = new AutoCloseSet();
        boolean rollback = false;
        boolean b = true;
        try {
            SQLInfo[] sqlInfos;
            sql = this.trans(sql);
            ShardingResult sr = engine.sharding(sql, params);
            boolean isPermittedMultiWrited = this.isPermittedMultiWrited(sr);
            if (!isPermittedMultiWrited) {
                this.checkMultiDBRouteWrited(sr);
            }
            int queryTimeoutSeconds = QueryTimeoutImpl.getQueryTimeoutSeconds();
            String mainRoute = ExtContext.get().getDBRoute();
            String curRoute = isPermittedMultiWrited ? mainRoute : this.getCurrentRoute(sr);
            TemptableFacadeResolver resolver = this.getTemptableFacadeResolver();
            this.handleTemptableForUpdate(curRoute, resolver, sr);
            for (SQLInfo si : sqlInfos = sr.getSQLInfos()) {
                this.checkExpectedActualRoute(si, curRoute);
                XDBLog.logSharding(si, this.isForManager());
                b &= this.doExecute(si.isShardingSQL(), autoCloseSet, this.markDialectSQL(si.getSql()), si.getParams(), XDBConnection.get().requireConnection(autoCloseSet, this.isForManager(), mainRoute, curRoute), queryTimeoutSeconds);
            }
        }
        catch (Exception e) {
            rollback = true;
            throw this.logAndConvertException(e);
        }
        finally {
            this.close(autoCloseSet, rollback);
        }
        return b;
    }

    /*
     * Exception decompiling
     */
    private boolean doExecute(boolean shardingSQL, AutoCloseSet autoCloseSet, String sql, Object[] params, Connection con, int queryTimeoutSeconds) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch(String sql, List<Object[]> paramsList) throws SQLException {
        int[] ret;
        block31: {
            if (paramsList == null || paramsList.isEmpty()) {
                return new int[]{this.update(sql, new Object[0])};
            }
            if (paramsList.size() == 1) {
                return new int[]{this.update(sql, paramsList.get(0))};
            }
            MetricsCollector mc = MetricsCollector.getCurrent();
            AutoCloseSet autoCloseSet = new AutoCloseSet();
            boolean rollback = false;
            try {
                sql = this.trans(sql);
                boolean isForManager = this.isForManager();
                int queryTimeoutSeconds = QueryTimeoutImpl.getQueryTimeoutSeconds();
                ShardingResult[] srs = engine.batchSharding(sql, paramsList);
                DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
                TemptableFacadeResolver resolver = this.getTemptableFacadeResolver();
                if (srs == null) {
                    XDBLog.logSharding(new SQLInfo(sql, paramsList.toArray(), false), this.isForManager());
                    String mainRoute = ExtContext.get().getDBRoute();
                    String curRoute = this.getCurrentRoute(null);
                    sql = this.handleTemptableSingle(curRoute, resolver, sql);
                    PreparedStatement ps = XDBPrepareStatement.get().prepareStatement(autoCloseSet, XDBConnection.get().requireConnection(autoCloseSet, isForManager, mainRoute, curRoute), sql, queryTimeoutSeconds, mc);
                    if (XDBConfig.paramUseOpenGaussFiller()) {
                        ParameterFillerFactory.getBatchSetter(dbType, false, ps).fill(paramsList);
                    } else {
                        new ParameterSetter.BatchSetter(false, ps).fill(paramsList);
                    }
                    ret = ps.executeBatch();
                    break block31;
                }
                boolean isPermittedMultiWrited = this.isPermittedMultiWrited(srs);
                if (!isPermittedMultiWrited) {
                    this.checkMultiDBRouteWrited(srs);
                }
                int paramsIndex = 0;
                HashMap<String, PreparedStatement> psMap = new HashMap<String, PreparedStatement>();
                HashMap batchSeqMap = new HashMap();
                AtomicInteger batchSeq = new AtomicInteger();
                ArrayList<Statement> stmts = new ArrayList<Statement>();
                Statement noParameterStmt = null;
                BatchUpdateResult bur = XDBConfig.paramUseOpenGaussFiller() ? new BatchUpdateResult(srs.length, dbType, true) : new BatchUpdateResult(srs.length, false);
                String mainRoute = ExtContext.get().getDBRoute();
                String curRoute = isPermittedMultiWrited ? mainRoute : this.getCurrentRoute(srs[0]);
                this.handleTemptableForUpdate(curRoute, resolver, srs);
                for (ShardingResult sr : srs) {
                    SQLInfo[] sqlInfos;
                    for (SQLInfo si : sqlInfos = sr.getSQLInfos()) {
                        this.checkExpectedActualRoute(si, curRoute);
                        Object[] aparams = si.getParams();
                        if (aparams == null || aparams.length == 0) {
                            XDBLog.logSharding(si, isForManager);
                            String noParameterSQL = this.markDialectSQL(si.getSql());
                            if (noParameterStmt == null) {
                                if (mc.isActionMetricEnabled()) {
                                    mc.collectSQL(noParameterSQL);
                                }
                                noParameterStmt = XDBStatement.get().createStatement(autoCloseSet, XDBConnection.get().requireConnection(autoCloseSet, isForManager, mainRoute, curRoute), queryTimeoutSeconds);
                                stmts.add(noParameterStmt);
                            }
                            noParameterStmt.addBatch(noParameterSQL);
                            bur.bind(noParameterStmt, paramsIndex);
                            continue;
                        }
                        PreparedStatement stmt = psMap.computeIfAbsent(si.getSql(), key -> {
                            try {
                                PreparedStatement ps = XDBPrepareStatement.get().prepareStatement(autoCloseSet, XDBConnection.get().requireConnection(autoCloseSet, isForManager, mainRoute, curRoute), (String)key, queryTimeoutSeconds, mc);
                                stmts.add(ps);
                                if (XDBLog.enableShardingOutSQL) {
                                    batchSeqMap.put(ps, batchSeq.incrementAndGet());
                                    XDBLog.logSharding(si, isForManager, "#batch-" + batchSeq.get() + " sql");
                                }
                                return ps;
                            }
                            catch (SQLException e) {
                                throw ExceptionUtil.wrap(e);
                            }
                        });
                        bur.bind(stmt, paramsIndex);
                        bur.addBatch(si.isShardingSQL(), stmt, aparams);
                    }
                    ++paramsIndex;
                }
                for (Statement stmt : stmts) {
                    try {
                        StatTimeStamp ss = mc.collectExecuteSpent();
                        Throwable throwable = null;
                        try {
                            if (XDBLog.enableShardingOutSQL && XDBLog.logWithParameter && !config.isEnableLogNoShardingSQL() && log.isInfoEnabled()) {
                                List<Object[]> pList = bur.getParamsList(stmt);
                                log.info("#batch-" + batchSeqMap.get(stmt) + " parameters(" + pList.size() + "): " + ArrayUtil.toParameterString(pList.toArray()));
                            }
                            bur.addBatchResult(stmt, stmt.executeBatch());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ss == null) continue;
                            if (throwable != null) {
                                try {
                                    ss.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ss.close();
                        }
                    }
                    finally {
                        stmt.close();
                    }
                }
                ret = bur.genBatchResult();
            }
            catch (Exception e) {
                rollback = true;
                throw this.logAndConvertException(e);
            }
            finally {
                this.close(autoCloseSet, rollback);
            }
        }
        return ret;
    }

    @Override
    public int[] executeBatch(String sql) throws SQLException {
        try {
            sql = this.trans(sql);
            ShardingResult sr = engine.sharding(sql, null);
            SQLInfo[] sqlInfos = sr.getSQLInfos();
            if (sqlInfos.length == 0) {
                return new int[0];
            }
            boolean isPermittedMultiWrited = this.isPermittedMultiWrited(sr);
            if (isPermittedMultiWrited) {
                return this.executeBatchForMultiRoute(sr);
            }
            return this.executeBatchForSingleRoute(sql, sr);
        }
        catch (Exception e) {
            throw this.logAndConvertException(e);
        }
    }

    private int[] executeBatchForMultiRoute(ShardingResult sr) throws SQLException {
        SQLInfo[] sqlInfos = sr.getSQLInfos();
        String mainRoute = ExtContext.get().getDBRoute();
        HashMap<String, List> sqlInfoMap = new HashMap<String, List>(2);
        for (SQLInfo sqlInfo : sqlInfos) {
            String curRoute = StringUtils.isEmpty((String)sqlInfo.getDbRoute()) ? mainRoute : sqlInfo.getDbRoute();
            List sqlInfoList = sqlInfoMap.computeIfAbsent(curRoute, key -> new ArrayList());
            sqlInfoList.add(sqlInfo);
        }
        int ret = 0;
        for (Map.Entry entry : sqlInfoMap.entrySet()) {
            String curRoute = (String)entry.getKey();
            List sqlInfoList = (List)entry.getValue();
            for (SQLInfo si : sqlInfoList) {
                XDBLog.logSharding(si, this.isForManager());
                Object[] params = si.getParams();
                String siSQL = params == null || params.length == 0 ? si.getSql() : SQLUtil.toSQLString(si.getSql(), params);
                siSQL = this.markDialectSQL(siSQL);
                XDBManageContext xm = XDB.get().withManageContext();
                Throwable throwable = null;
                try {
                    XDBExternal xdbe = XDBExternal.requiresNew("executeBatchForMultiRoute");
                    Throwable throwable2 = null;
                    try {
                        boolean executed = xdbe.execute(curRoute, siSQL);
                        ret += executed ? 1 : 0;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (xdbe == null) continue;
                        if (throwable2 != null) {
                            try {
                                xdbe.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        xdbe.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (xm == null) continue;
                    if (throwable != null) {
                        try {
                            xm.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    xm.close();
                }
            }
        }
        return new int[]{ret};
    }

    /*
     * Exception decompiling
     */
    private int[] executeBatchForSingleRoute(String sql, ShardingResult sr) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public XDBManageContext withManageContext() throws SQLException {
        final MetricsCollector mc = MetricsCollector.getCurrent();
        XDBManageContext ctx = new XDBManageContext(){
            private String route;

            @Override
            public void close() {
                ((LinkedList)manageContextListTH.get()).removeLast();
                MetricsCollector.setCurrent(mc);
            }

            @Override
            public void setRoute(String dbRoute) {
                this.route = dbRoute;
            }

            @Override
            public String getRoute() {
                return this.route;
            }
        };
        LinkedList<XDBManageContext> ctxList = manageContextListTH.get();
        if (ctxList == null) {
            ctxList = new LinkedList();
            manageContextListTH.set(ctxList);
        }
        ctxList.add(ctx);
        mc.subCollector().sqlFeature().setManagerSQL(true);
        return ctx;
    }

    @Override
    public boolean atParallelThread() {
        return Thread.currentThread() instanceof ParallelExecutor.ParallelThread;
    }

    private final boolean isForManager() {
        LinkedList<XDBManageContext> ctxList = manageContextListTH.get();
        return ctxList != null && !ctxList.isEmpty();
    }

    private final String forManagerRoute() {
        if (this.isForManager()) {
            XDBManageContext manageContext = manageContextListTH.get().getLast();
            return manageContext.getRoute();
        }
        return null;
    }

    private final String getCurrentRoute(ShardingResult sr) {
        if (this.isForManager() && null != this.forManagerRoute()) {
            return this.forManagerRoute();
        }
        if (sr != null && !StringUtils.isEmpty((String)sr.getSQLInfos()[0].getDbRoute())) {
            return sr.getSQLInfos()[0].getDbRoute();
        }
        return ExtContext.get().getDBRoute();
    }

    private void close(AutoCloseSet autoCloseSet, boolean rollback) throws SQLException {
        autoCloseSet.close(rollback);
    }

    private String markDialectSQL(String sql) {
        sql = NoShardingHint.removeNoShardingSQL(sql);
        if (config.isUseKSQL()) {
            return sql;
        }
        return KSQL.dialect(sql);
    }

    @Override
    public boolean existTable(String tableName) throws SQLException {
        return XDBConfig.getTableManager().existTable(tableName);
    }

    @Override
    public String[] getExistShardingTables(String tableName) throws SQLException {
        return XDBConfig.getTableManager().getShardingTable(tableName);
    }

    private String trans(String sql) throws SQLException {
        KSQLTransfer sqlTransfer;
        if (!config.isUseKSQL() && (sqlTransfer = config.getKSqlTransfer()) != null) {
            DBType dbType = ConnectionProvider.get().getConnectionHolder().getDBType();
            sql = NoShardingHint.genNoShardingSQL(sqlTransfer.trans(sql, dbType));
        }
        return sql;
    }

    @Override
    public QueryTimeout timeout(int seconds) {
        return QueryTimeoutImpl.timeout(seconds);
    }

    private SQLException logAndConvertException(Exception e) {
        return ExceptionUtil.as(SQLException.class, e);
    }

    private static class BatchUpdateResult {
        Map<Statement, Integer> batchIndexMap = new HashMap<Statement, Integer>();
        Map<Statement, int[]> resultMap = new ConcurrentHashMap<Statement, int[]>();
        Map<Statement, List<PItem>> piitemListMap = new HashMap<Statement, List<PItem>>();
        Map<Statement, List<PItemUseOpenGaussFiller>> pItemUseOpenGaussFillerListMap = new HashMap<Statement, List<PItemUseOpenGaussFiller>>();
        final int[] ret;
        final boolean useOpenGaussBatch;
        DBType dbType;

        BatchUpdateResult(int count, boolean useOpenGaussBatch) {
            this.ret = new int[count];
            this.useOpenGaussBatch = useOpenGaussBatch;
        }

        BatchUpdateResult(int count, DBType dbType, boolean useOpenGaussBatch) {
            this.ret = new int[count];
            this.dbType = dbType;
            this.useOpenGaussBatch = useOpenGaussBatch;
        }

        void bind(Statement stmt, int paramsIndex) {
            int batchIndex = this.batchIndexMap.computeIfAbsent(stmt, t -> 0);
            this.doBind(stmt, paramsIndex, batchIndex);
            this.batchIndexMap.put(stmt, ++batchIndex);
        }

        void doBind(Statement stmt, int paramsIndex, int batchIndex) {
            if (this.useOpenGaussBatch) {
                PItemUseOpenGaussFiller pitemUseOpenGauss = new PItemUseOpenGaussFiller();
                pitemUseOpenGauss.paramsIndex = paramsIndex;
                pitemUseOpenGauss.batchIndex = batchIndex;
                List<PItemUseOpenGaussFiller> piitemUseOpenGaussList = this.pItemUseOpenGaussFillerListMap.get(stmt);
                if (piitemUseOpenGaussList == null) {
                    piitemUseOpenGaussList = new ArrayList<PItemUseOpenGaussFiller>();
                    this.pItemUseOpenGaussFillerListMap.put(stmt, piitemUseOpenGaussList);
                }
                piitemUseOpenGaussList.add(pitemUseOpenGauss);
            } else {
                PItem pitem = new PItem();
                pitem.paramsIndex = paramsIndex;
                pitem.batchIndex = batchIndex;
                List<PItem> piitemList = this.piitemListMap.get(stmt);
                if (piitemList == null) {
                    piitemList = new ArrayList<PItem>();
                    this.piitemListMap.put(stmt, piitemList);
                }
                piitemList.add(pitem);
            }
        }

        void addBatch(boolean isShardingSQL, PreparedStatement ps, Object[] params) throws SQLException {
            if (this.useOpenGaussBatch) {
                PItemUseOpenGaussFiller pitemUseOpenGauss = this.pItemUseOpenGaussFillerListMap.get(ps).get(0);
                if (pitemUseOpenGauss.setter0 == null) {
                    pitemUseOpenGauss.setter0 = ParameterFillerFactory.getBatchSetter(this.dbType, isShardingSQL, ps);
                    pitemUseOpenGauss.parmasList0 = new ArrayList<Object[]>(256);
                }
                pitemUseOpenGauss.setter0.fill(params);
                pitemUseOpenGauss.parmasList0.add(params);
            } else {
                PItem pitem = this.piitemListMap.get(ps).get(0);
                if (pitem.setter0 == null) {
                    pitem.setter0 = new ParameterSetter.BatchSetter(isShardingSQL, ps);
                    pitem.parmasList0 = new ArrayList<Object[]>(256);
                }
                pitem.setter0.fill(params);
                pitem.parmasList0.add(params);
            }
        }

        List<Object[]> getParamsList(Statement stmt) {
            return this.useOpenGaussBatch ? this.pItemUseOpenGaussFillerListMap.get((Object)stmt).get((int)0).parmasList0 : this.piitemListMap.get((Object)stmt).get((int)0).parmasList0;
        }

        void addBatchResult(Statement stmt, int[] ret) {
            this.resultMap.put(stmt, ret);
        }

        int[] genBatchResult() {
            for (Map.Entry<Statement, int[]> e : this.resultMap.entrySet()) {
                List<Object> piitemList;
                Statement stmt = e.getKey();
                int[] uc = this.resultMap.get(stmt);
                if (uc.length == 0) continue;
                if (this.useOpenGaussBatch) {
                    piitemList = this.pItemUseOpenGaussFillerListMap.get(stmt);
                    for (PItemUseOpenGaussFiller pItemUseOpenGaussFiller : piitemList) {
                        int n = pItemUseOpenGaussFiller.paramsIndex;
                        this.ret[n] = this.ret[n] + uc[pItemUseOpenGaussFiller.batchIndex];
                    }
                    continue;
                }
                piitemList = this.piitemListMap.get(stmt);
                for (PItem pItem : piitemList) {
                    int n = pItem.paramsIndex;
                    this.ret[n] = this.ret[n] + uc[pItem.batchIndex];
                }
            }
            return this.ret;
        }

        static class PItemUseOpenGaussFiller {
            int paramsIndex;
            int batchIndex;
            AbstractBatchFiller setter0;
            List<Object[]> parmasList0;

            PItemUseOpenGaussFiller() {
            }
        }

        static class PItem {
            int paramsIndex;
            int batchIndex;
            ParameterSetter.BatchSetter setter0;
            List<Object[]> parmasList0;

            PItem() {
            }
        }
    }
}

