/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb;

import java.sql.ResultSet;
import java.util.function.Consumer;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.ext.ExtContext;
import kd.bos.xdb.util.Closeable;
import kd.bos.xdb.util.ObjectRefer;

public abstract class XDBExternal
implements AutoCloseable {
    private static final ThreadLocal<ObjectRefer> thSkipTransaction = ThreadLocals.create();

    public static XDBExternal requiresNew(String tag) {
        XDBExternal xe = XDBConfig.getXDBExternalSupplier().get();
        xe.doRequiresNew(tag);
        return xe;
    }

    public static XDBExternal notSupported(String tag) {
        XDBExternal xe = XDBConfig.getXDBExternalSupplier().get();
        xe.doNotSupported(tag);
        return xe;
    }

    public static XDBExternal notSupportedAlways(String tag) {
        ObjectRefer refer = thSkipTransaction.get();
        if (refer == null) {
            refer = new ObjectRefer();
        } else {
            ObjectRefer cur = new ObjectRefer();
            cur.setRef(refer);
            refer = cur;
        }
        thSkipTransaction.set(refer);
        XDBExternal xe = XDBExternal.notSupported(tag);
        ObjectRefer r = refer;
        xe.addCloseableListener(() -> {
            ObjectRefer parent = (ObjectRefer)r.getRef();
            if (parent == null) {
                thSkipTransaction.remove();
            } else {
                thSkipTransaction.set(parent);
            }
        });
        return xe;
    }

    public static boolean isNotSupportedAlways() {
        return thSkipTransaction.get() != null;
    }

    protected abstract void doRequiresNew(String var1);

    protected abstract void doNotSupported(String var1);

    protected abstract void addCloseableListener(Closeable var1);

    public abstract void markRollback();

    @Override
    public abstract void close();

    protected abstract boolean doExecute(String var1, String var2, Object[] var3);

    protected abstract void doQuery(String var1, String var2, Object[] var3, Consumer<ResultSet> var4);

    public abstract boolean isUseTheSameDatabase(String ... var1);

    public boolean execute(String sql) {
        return this.doExecute(ExtContext.get().getDBRoute(), sql, null);
    }

    public boolean execute(String sql, Object[] params) {
        return this.doExecute(ExtContext.get().getDBRoute(), sql, params);
    }

    public boolean execute(String dbRoute, String sql) {
        return this.doExecute(dbRoute, sql, null);
    }

    public boolean execute(String dbRoute, String sql, Object[] params) {
        return this.doExecute(dbRoute, sql, params);
    }

    public void query(String sql, Object[] params, Consumer<ResultSet> rsConsumer) {
        this.doQuery(ExtContext.get().getDBRoute(), sql, params, rsConsumer);
    }

    public void query(String dbRoute, String sql, Object[] params, Consumer<ResultSet> rsConsumer) {
        this.doQuery(dbRoute, sql, params, rsConsumer);
    }
}

