/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.cache;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.util.LRUCacheMap;

public abstract class AbstractCache
implements Cache {
    protected int level = 1;
    protected final Map<String, Map<Object, Object>> maps = new ConcurrentHashMap<String, Map<Object, Object>>(128);

    @Override
    public void initCacheSize(String type, int cacheSize) {
        Map<Object, Object> synchronizedMap = this.getTypeMap(type);
        try {
            Field f = synchronizedMap.getClass().getDeclaredField("m");
            f.setAccessible(true);
            LRUCacheMap map = (LRUCacheMap)f.get(synchronizedMap);
            map.setCacheSize(cacheSize);
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }

    public Map<Object, Object> getTypeMap(String type) {
        Map ret = this.maps.get(type);
        if (ret == null) {
            ret = this.maps.computeIfAbsent(type, k -> Collections.synchronizedMap(new LRUCacheMap(XDBConfig.get().getCacheDefaultSize())));
        }
        return ret;
    }

    @Override
    public Object setIfAbsent(String type, Object key, Function<Object, Object> mappingFunction) {
        return this.getTypeMap(type).computeIfAbsent(key, mappingFunction);
    }

    @Override
    public void set(String type, Object key, Object value) {
        this.getTypeMap(type).put(key, value);
    }

    @Override
    public Object get(String type, Object key) {
        return this.getTypeMap(type).get(key);
    }

    @Override
    public void remove(String type, Object key) {
        this.getTypeMap(type).remove(key);
    }

    @Override
    public void clear(String type) {
        this.maps.remove(type);
    }

    @Override
    public void clearAll() {
        this.maps.clear();
    }

    @Override
    public int getLevel() {
        return this.level;
    }
}

