/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.executor.ExecutorCache;
import kd.bos.xdb.cache.executor.temp.MoveShardingDataTempCache;
import kd.bos.xdb.cache.global.GlobalCache;
import kd.bos.xdb.cache.tx.TXCache;
import kd.bos.xdb.eventbus.RequestContextInfo;

public final class CacheContext {
    private Cache currentCache;
    private static final Map<String, Cache> globalCacheMap = new ConcurrentHashMap<String, Cache>();
    private static final ThreadLocal<CacheContext> thCacheContext = ThreadLocals.create(() -> {
        RequestContextInfo rc = RequestContextInfo.get();
        String key = rc.getTenantId() + '#' + rc.getAccountId();
        Cache globalCache = globalCacheMap.get(key);
        if (globalCache == null) {
            globalCache = globalCacheMap.computeIfAbsent(key, k -> new GlobalCache());
        }
        return new CacheContext(globalCache);
    });

    private CacheContext(Cache globalCache) {
        this.currentCache = globalCache;
    }

    public Cache createTXCache() {
        Cache old = this.currentCache;
        this.currentCache = new TXCache(this.currentCache, () -> {
            this.currentCache = old;
        });
        return this.currentCache;
    }

    public Cache createExecutorCache() {
        Cache old = this.currentCache;
        this.currentCache = new ExecutorCache(this.currentCache, () -> {
            this.currentCache = old;
        });
        return this.currentCache;
    }

    public MoveShardingDataTempCache createTempCache() {
        Cache old = this.currentCache;
        this.currentCache = new MoveShardingDataTempCache(this.currentCache, () -> {
            this.currentCache = old;
        });
        return this.currentCache;
    }

    public Cache getCurrentCache() {
        return this.currentCache;
    }

    public static CacheContext get() {
        return thCacheContext.get();
    }
}

