/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.cache.tx;

import java.util.Map;
import kd.bos.xdb.cache.AbstractCache;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.RollbackableCache;
import kd.bos.xdb.util.Closeable;

public class TXCache
extends AbstractCache
implements RollbackableCache {
    private final Cache parent;
    private boolean rollbacked;
    protected final Closeable onClosed;

    public TXCache(Cache parent, Closeable onClosed) {
        this.parent = parent;
        this.onClosed = onClosed;
        this.level = parent.getLevel() + 1;
    }

    @Override
    public Object get(String type, Object key) {
        Object value = this.getTypeMap(type).get(key);
        if (value == null) {
            value = this.parent.get(type, key);
        }
        return value;
    }

    @Override
    public void close() {
        if (!this.rollbacked) {
            this.flushCache(this.isFlushRecursive());
        }
        this.onClosed.close();
    }

    protected boolean isFlushRecursive() {
        return false;
    }

    private void flushCache(boolean recursive) {
        if (!this.maps.isEmpty()) {
            AbstractCache cc = (AbstractCache)this.parent;
            if (this.currentIsTXBound()) {
                do {
                    for (Map.Entry entry : this.maps.entrySet()) {
                        Map map = (Map)entry.getValue();
                        if (map.isEmpty()) continue;
                        cc.getTypeMap((String)entry.getKey()).putAll(map);
                    }
                } while ((cc = (AbstractCache)cc.getParent()) != null);
            } else {
                for (Map.Entry entry : this.maps.entrySet()) {
                    Map map = (Map)entry.getValue();
                    if (map.isEmpty()) continue;
                    cc.getTypeMap((String)entry.getKey()).putAll(map);
                }
                if (recursive) {
                    ((TXCache)cc).flushCache(true);
                }
            }
        }
    }

    protected boolean currentIsTXBound() {
        return true;
    }

    @Override
    public final Cache getParent() {
        return this.parent;
    }

    @Override
    public void remove(String type, Object key) {
        this.getTypeMap(type).remove(key);
        this.parent.remove(type, key);
    }

    @Override
    public void clear(String type) {
        this.maps.remove(type);
        this.parent.clear(type);
    }

    @Override
    public void clearAll() {
        this.maps.clear();
        this.parent.clearAll();
    }

    @Override
    public boolean isRollbacked() {
        return this.rollbacked;
    }

    @Override
    public void setRollbacked(boolean rollbacked) {
        this.rollbacked = rollbacked;
    }
}

