/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

class DataSourceCreator {
    private static final long CONNECTION_TIMEOUT_MS = 60000L;
    private static final int SET_MINIMUM_IDLE = 2;
    private static final int SET_MAXIMUM_POOL_SIZE = 200;

    DataSourceCreator() {
    }

    public static HikariDataSource hikariDataSource(Properties ps) throws Exception {
        ps = DataSourceCreator.createPropertiesWithDefault(ps);
        HikariConfig config = new HikariConfig();
        String driverClassName = ps.getProperty("driverClassName");
        if (driverClassName != null) {
            config.setDriverClassName(driverClassName);
        }
        config.setJdbcUrl(ps.getProperty("url"));
        config.setUsername(ps.getProperty("username"));
        config.setPassword(ps.getProperty("password"));
        config.setAutoCommit(false);
        config.setConnectionTestQuery(ps.getProperty("validationQuery", "select 1"));
        config.setConnectionTimeout(60000L);
        config.setMinimumIdle(2);
        config.setMaximumPoolSize(200);
        config.setMaxLifetime(0L);
        config.setPoolName(DataSourceCreator.maskJMXName(DataSourceCreator.getDSName(ps)));
        config.setDataSourceProperties(ps);
        return new HikariDataSource(config);
    }

    public static DataSource druidDataSource(Properties ps) throws Exception {
        ps = DataSourceCreator.createPropertiesWithDefault(ps);
        DruidDataSource ds = (DruidDataSource)DruidDataSourceFactory.createDataSource((Properties)ps);
        ds.setName(DataSourceCreator.maskJMXName(DataSourceCreator.getDSName(ps)));
        return ds;
    }

    private static String getDSName(Properties ps) {
        String name = ps.getProperty("name");
        if (name == null) {
            name = "DataSourcePool";
            try {
                name = name + "-" + InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            name = name + "-" + System.currentTimeMillis();
        }
        return ps.getProperty("name", name);
    }

    private static String maskJMXName(String dsName) {
        StringBuilder s = new StringBuilder(dsName.length());
        for (char ch : dsName.toCharArray()) {
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') {
                s.append(ch);
                continue;
            }
            s.append('_');
        }
        return s.toString();
    }

    private static Properties createPropertiesWithDefault(Properties ps) {
        Properties pros = new Properties();
        DataSourceCreator.setDefault(pros);
        if (ps != null) {
            pros.putAll((Map<?, ?>)ps);
        }
        return pros;
    }

    private static void setDefault(Properties ps) {
        ps.setProperty("defaultAutoCommit", "false");
        ps.setProperty("validationQuery", "SELECT 1");
        ps.setProperty("testOnBorrow", "true");
        ps.setProperty("testWhileIdle", "true");
        ps.setProperty("timeBetweenEvictionRunsMillis", "600000");
        ps.setProperty("timeBetweenConnectErrorMillis", "180000");
    }
}

