/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.datasource;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.bundle.BosRes;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.ExceptionUtil;

@Deprecated
class DataSourceURLs {
    private static final String PROPERTY_MYSQL_MARIADB = "datasource.mariadb";

    DataSourceURLs() {
    }

    private static boolean isUseMariaDbDriver() {
        return Boolean.parseBoolean(System.getProperty(PROPERTY_MYSQL_MARIADB, "false"));
    }

    public static String genURL(DBType dbType, String ip, int port, String db) {
        String appendURL = System.getProperty("db.url.append", "");
        String url = DataSourceURLs.genURL0(dbType, ip, port, db);
        url = DataSourceURLs.appendURL(url, appendURL);
        if (dbType == DBType.mysql) {
            url = DataSourceURLs.appendURL(url, DataSourceURLs.getDefaultMySqlAppendURL());
        }
        return url;
    }

    private static String genURL0(DBType dbType, String ip, int port, String db) {
        switch (dbType) {
            case oracle: {
                return "jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle10:jdbc:oracle:thin:@" + ip + ":" + port + "/" + db;
            }
            case mysql: {
                String url = DataSourceURLs.isUseMariaDbDriver() ? "jdbc:ksql:org.mariadb.jdbc.Driver:dbtype=mysql:jdbc:mariadb://" + ip + ":" + port + "/" + db : "jdbc:ksql:com.mysql.cj.jdbc.Driver:dbtype=mysql:jdbc:mysql://" + ip + ":" + port + "/" + db;
                return url;
            }
            case postgresql: {
                return "jdbc:ksql:org.postgresql.Driver:dbtype=postgresql:jdbc:postgresql://" + ip + ":" + port + "/" + db;
            }
            case gs100: {
                return "jdbc:ksql:org.postgresql.Driver:dbtype=gs:jdbc:postgresql://" + ip + ":" + port + "/" + db;
            }
            case gs: {
                return "jdbc:ksql:com.huawei.gauss.jdbc.ZenithDriver:dbtype=gs100:jdbc:zenith:@" + ip + ":" + port;
            }
            case gaussdb: {
                return "jdbc:ksql:com.huawei.opengauss.jdbc.Driver:dbtype=gaussdb:jdbc:opengauss://" + ip + ":" + port + "/" + db;
            }
            case dm: {
                return "jdbc:ksql:dm.jdbc.driver.DmDriver:dbtype=dm:jdbc:dm://" + ip + ":" + port + "/" + db;
            }
            case sqlserver: {
                return "jdbc:ksql:com.microsoft.sqlserver.jdbc.SQLServerDriver:dbtype=sqlserver:jdbc:sqlserver://" + ip + ":" + port + ";DatabaseName=" + db;
            }
            case kingbase: {
                return "jdbc:ksql:com.kingbase8.Driver:dbtype=kingbase:jdbc:kingbase8://" + ip + ":" + port + "/" + db;
            }
        }
        throw ExceptionUtil.wrap(BosRes.get((String)"bos-xdb", (String)"DataSourceURLs_0", (String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u5e93\u7c7b\u578b{0}:ip={1}, port={2}, db={3}\u3002", (Object[])new Object[]{dbType, ip, port, db}));
    }

    private static String appendURL(String url, String appendURL) {
        int p = url.indexOf(63);
        Map<Object, Object> existsMap = p != -1 ? DataSourceURLs.toMap(url.substring(p + 1)) : new HashMap();
        StringBuilder sb = new StringBuilder(url);
        int link = p == -1 ? 63 : 38;
        Map<String, String> appendMap = DataSourceURLs.toMap(appendURL);
        for (Map.Entry<String, String> entry : appendMap.entrySet()) {
            String key = entry.getKey();
            if (existsMap.containsKey(key)) continue;
            sb.append((char)link).append(key).append('=').append(entry.getValue());
            link = 38;
        }
        return sb.toString();
    }

    private static Map<String, String> toMap(String appendURL) {
        String[] ps;
        if (appendURL.startsWith("&") || appendURL.startsWith("?")) {
            appendURL = appendURL.substring(1);
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String s : ps = appendURL.split("&")) {
            int eq = s.indexOf(61);
            if (eq == -1 || eq == s.length() - 1) continue;
            map.put(s.substring(0, eq), s.substring(eq + 1));
        }
        return map;
    }

    private static String getDefaultMySqlAppendURL() {
        String serverTimezone = System.getProperty("mysql.serverTimezone", "Asia/Shanghai");
        String common = "serverTimezone=" + serverTimezone + "&zeroDateTimeBehavior=round&useUnicode=true&characterEncoding=UTF-8&rewriteBatchedStatements=true";
        String fetch = "&allowLoadLocalInfile=true&allowMultiQueries=true&defaultFetchSize=1000&useCursorFetch=true&useServerPrepStmts=true&cachePrepStmts=true&prepStmtCacheSize=1024&prepStmtCacheSqlLimit=4096";
        String batch = "&useServerPrepStmts=false&useCompression=true";
        return common + "&allowLoadLocalInfile=true&allowMultiQueries=true&defaultFetchSize=1000&useCursorFetch=true&useServerPrepStmts=true&cachePrepStmts=true&prepStmtCacheSize=1024&prepStmtCacheSqlLimit=4096";
    }
}

