/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.engine.BatchShardingContext;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.strategy.ShardingStrategy;
import kd.bos.xdb.sharding.strategy.children.ChildrenStrategy;
import kd.bos.xdb.tablemanager.TableName;

public final class ShardingContext
implements AutoCloseable {
    private static ThreadLocal<ShardingContext> th = ThreadLocals.create();
    private ShardingContext parent;
    private boolean genShardingIndexWhenSharding = false;
    private StatementType statementType;
    private boolean updateShardingFieldAndIndexPrepared = false;
    private Set<Long> updateShardingFieldToNewTables = null;
    private Map<ShardingStrategy, String[]> hintShardingTablesMap = new HashMap<ShardingStrategy, String[]>();
    private boolean mapTableLoaded = false;

    public static ShardingContext get() {
        return th.get();
    }

    public static ShardingContext create() {
        return new ShardingContext();
    }

    private ShardingContext() {
        this.parent = th.get();
        th.set(this);
    }

    public ShardingContext getParent() {
        return this.parent;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public boolean shouldGenShardingIndex() {
        return this.genShardingIndexWhenSharding || this.statementType == StatementType.insert;
    }

    public boolean __getGenShardingIndexWhenSharding() {
        return this.genShardingIndexWhenSharding;
    }

    public void setGenShardingIndexWhenSharding(boolean genShardingIndexWhenSharding) {
        this.genShardingIndexWhenSharding = genShardingIndexWhenSharding;
    }

    public boolean isUpdateShardingFieldAndIndexPrepared() {
        return this.updateShardingFieldAndIndexPrepared;
    }

    public void setUpdateShardingFieldAndIndexPrepared(boolean updateShardingFieldAndIndexPrepared) {
        this.updateShardingFieldAndIndexPrepared = updateShardingFieldAndIndexPrepared;
    }

    public Set<Long> getUpdateShardingFieldToNewTables() {
        return this.updateShardingFieldToNewTables;
    }

    public void setUpdateShardingFieldToNewTables(Set<Long> updateShardingFieldToNewTables) {
        this.updateShardingFieldToNewTables = updateShardingFieldToNewTables;
    }

    public String[] getHintShardingTables(ShardingStrategy strategy) {
        while (strategy instanceof ChildrenStrategy) {
            strategy = ((ChildrenTableConfig)((ChildrenStrategy)strategy).getConfig()).getParent().getShardingStrategy();
        }
        return this.hintShardingTablesMap.get(strategy);
    }

    public void setHintShardingTables(ShardingStrategy strategy, String[] hintShardingTables) {
        while (strategy instanceof ChildrenStrategy) {
            strategy = ((ChildrenTableConfig)((ChildrenStrategy)strategy).getConfig()).getParent().getShardingStrategy();
        }
        if (hintShardingTables == null) {
            this.hintShardingTablesMap.remove(strategy);
        } else {
            for (int i = 0; i < hintShardingTables.length; ++i) {
                hintShardingTables[i] = TableName.of(strategy.getConfig().getTable()).getShardingTable(TableName.of(hintShardingTables[i]).getSuffix());
            }
            this.hintShardingTablesMap.put(strategy, hintShardingTables);
        }
    }

    public boolean isMapTableLoaded() {
        BatchShardingContext bctx = BatchShardingContext.get();
        if (bctx != null) {
            return bctx.isMapTableLoaded();
        }
        return this.mapTableLoaded;
    }

    public void setMapTableLoaded(boolean mapTableLoaded) {
        BatchShardingContext bctx = BatchShardingContext.get();
        if (bctx != null) {
            bctx.setMapTableLoaded(mapTableLoaded);
        } else {
            this.mapTableLoaded = mapTableLoaded;
        }
    }

    @Override
    public void close() {
        th.set(this.parent);
    }
}

