/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.engine;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.engine.UnionType;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.parser.SQLUtil;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.sql.visitor.ResolvePropertyOwnerVisitor;
import kd.bos.xdb.tablemanager.TableName;

public class ShardingResult {
    private SQLInfo[] si;
    private StatementInfo stmtInfo;
    private SelectFeature unionRootSelectFeature;
    private final SelectFeature selectFeature;
    private final SQLSelectStatement parentStmt;
    private final UnionType unionType;
    private final ShardingResult unionNext;

    public static ShardingResult noShardingResult(SQLInfo[] si) {
        return new ShardingResult(si, null, null);
    }

    public static ShardingResult shardingResult(SQLInfo[] si, StatementInfo stmtInfo, SelectFeature selectFeature) {
        return new ShardingResult(si, stmtInfo, selectFeature);
    }

    public static ShardingResult shardingResultWithUnion(SQLInfo[] si, StatementInfo stmtInfo, UnionType unionType, ShardingResult unionNext, SQLSelectStatement parentStmt, SelectFeature selectFeature) {
        return new ShardingResult(si, stmtInfo, unionType, unionNext, parentStmt, selectFeature);
    }

    private ShardingResult(SQLInfo[] si, StatementInfo stmtInfo, SelectFeature selectFeature) {
        this(si, stmtInfo, null, null, null, selectFeature);
    }

    private ShardingResult(SQLInfo[] si, StatementInfo stmtInfo, UnionType type, ShardingResult next, SQLSelectStatement parentStmt, SelectFeature selectFeature) {
        this.si = si;
        this.stmtInfo = stmtInfo;
        this.unionType = type;
        this.unionNext = next;
        this.parentStmt = parentStmt;
        this.selectFeature = selectFeature;
    }

    ShardingResult shareShardingResult(Object[] params) {
        SQLInfo[] si = new SQLInfo[this.si.length];
        for (int i = 0; i < si.length; ++i) {
            si[i] = new SQLInfo(this.si[i].getDbRoute(), this.si[i].getSql(), params, true);
        }
        return new ShardingResult(si, this.stmtInfo, this.unionType, this.unionNext, this.parentStmt, this.selectFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ShardingResult shareShardingResult(Object[] params, Long[] indexs) {
        int N = indexs.length;
        ArrayList<SQLInfo> siList = new ArrayList<SQLInfo>(indexs.length * 2);
        SQLStatement stmt = this.stmtInfo.getSQLStatement();
        TableInfo shardingTable = this.stmtInfo.getTableInfos().get(0);
        SQLExpr originTableExpr = shardingTable.getSQLTableSource().getExpr();
        try {
            for (int i = 0; i < N; ++i) {
                shardingTable.getSQLTableSource().setExpr(SQLUtil.wrapSQLTableName(TableName.of(shardingTable.getName()).getShardingTable(indexs[i])));
                stmt.accept((SQLASTVisitor)new ResolvePropertyOwnerVisitor());
                String dbRoute = XDBConfig.getShardingConfigProvider().getMainConfig(TableName.of(shardingTable.getName()).getOriginalName()).getOptions().getIndexRoute().getRoute(indexs[i]);
                SQLInfo si = new SQLInfo(dbRoute, stmt.toString(), params, true);
                siList.add(si);
                if (this.stmtInfo.getStatementType() != StatementType.delete) continue;
                TableName tn = TableName.of(shardingTable.getName());
                String pkTable = tn.getPKTable();
                String sql = "DELETE FROM " + pkTable + " WHERE FPK = ? ";
                SQLInfo deletePkSi = new SQLInfo(dbRoute, sql, params, true);
                siList.add(deletePkSi);
            }
            ShardingResult shardingResult = new ShardingResult(siList.toArray(new SQLInfo[siList.size()]), this.stmtInfo, this.unionType, this.unionNext, this.parentStmt, this.selectFeature);
            return shardingResult;
        }
        finally {
            shardingTable.getSQLTableSource().setExpr(originTableExpr);
            stmt.accept((SQLASTVisitor)new ResolvePropertyOwnerVisitor());
        }
    }

    public SQLInfo[] getSQLInfos() {
        return this.si;
    }

    public StatementInfo getStatementInfo() {
        return this.stmtInfo;
    }

    public boolean withUnion() {
        return this.unionNext != null;
    }

    public UnionType getUnionType() {
        return this.unionType;
    }

    public ShardingResult getUnionShardingResult() {
        return this.unionNext;
    }

    public SQLSelectStatement getParentStmt() {
        return this.parentStmt;
    }

    public SelectFeature getSelectFeature() {
        return this.selectFeature;
    }

    public SelectFeature getUnionRootSelectFeature() {
        return this.unionRootSelectFeature;
    }

    public void setUnionRootSelectFeature(SelectFeature unionRootSelectFeature) {
        this.unionRootSelectFeature = unionRootSelectFeature;
    }
}

