/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.engine.spec;

import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import kd.bos.xdb.engine.spec.SelfSharding;
import kd.bos.xdb.engine.spec.join.ShardingJoin;
import kd.bos.xdb.engine.spec.subquery.SimpleInSubQuery;
import kd.bos.xdb.merge.feature.MergeFeatureVisitor;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.sharding.config.ChildrenTableConfig;
import kd.bos.xdb.sharding.config.MainTableConfig;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.sql.visitor.TableVisitor;

public class SpecUtil {
    public static Optional<SelfSharding> specSharding(StatementInfo stmtInfo, ShardingConfigProvider scp, SelectFeature sf) {
        StatementType statementType = stmtInfo.getStatementType();
        switch (statementType) {
            case select: {
                if (SpecUtil.withJoinXdbExcludeInner(stmtInfo, scp) || SpecUtil.withExistsXdb(stmtInfo, scp)) {
                    return Optional.of(new ShardingJoin(stmtInfo, scp));
                }
                if (!SpecUtil.simpleInSubQuery(stmtInfo, scp)) break;
                return Optional.of(new SimpleInSubQuery(stmtInfo, scp, sf));
            }
        }
        return Optional.empty();
    }

    private static boolean withJoinXdbExcludeInner(StatementInfo stmtInfo, ShardingConfigProvider scp) {
        SQLExprTableSource tableSource;
        boolean isWithJoin = false;
        boolean joinSameConfig = false;
        ArrayList<ShardingConfig> configs = new ArrayList<ShardingConfig>(10);
        HashSet<String> mainConfigs = new HashSet<String>(10);
        ArrayList<SQLJoinTableSource> joinTableSources = new ArrayList<SQLJoinTableSource>(10);
        ShardingConfig headTableConfig = null;
        for (SQLJoinTableSource joinTableInfo : stmtInfo.getJoinTableInfos()) {
            joinTableSources.add(joinTableInfo);
            tableSource = null;
            if (joinTableInfo.getJoinType().name.equals(SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN.name)) {
                tableSource = SpecUtil.getLeftJoinRootTableSource(joinTableInfo);
                SpecUtil.collectLeftJoinTableSource(joinTableInfo, joinTableSources);
            } else if (joinTableInfo.getJoinType().name.equals(SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN.name)) {
                tableSource = SpecUtil.getRightJoinRootTableSource(joinTableInfo);
                SpecUtil.collectRightJoinTableSource(joinTableInfo, joinTableSources);
            }
            if (null == tableSource || (headTableConfig = scp.getConfig(tableSource.getTableName())) == null) continue;
            configs.add(headTableConfig);
        }
        for (SQLJoinTableSource joinTableInfo : joinTableSources) {
            tableSource = null;
            if (joinTableInfo.getJoinType().name.equals(SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN.name)) {
                tableSource = joinTableInfo.getRight();
            } else if (joinTableInfo.getJoinType().name.equals(SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN.name)) {
                tableSource = joinTableInfo.getLeft();
            }
            if (null == tableSource) continue;
            TableVisitor tv = TableVisitor.create();
            tableSource.accept((SQLASTVisitor)tv);
            for (SQLExprTableSource exp : tv.getTableSources()) {
                String tableName = exp.getTableName();
                ShardingConfig tableConfig = scp.getConfig(tableName);
                if (tableConfig == null) continue;
                if (configs.contains(tableConfig)) {
                    joinSameConfig = true;
                }
                configs.add(tableConfig);
                isWithJoin = true;
            }
        }
        if (headTableConfig != null && isWithJoin) {
            boolean isFamily = false;
            for (ShardingConfig config : configs) {
                ShardingConfig grdParent;
                if (config instanceof MainTableConfig) {
                    mainConfigs.add(config.getTable().toLowerCase());
                    continue;
                }
                if (!(config instanceof ChildrenTableConfig)) continue;
                ShardingConfig parent = ((ChildrenTableConfig)config).getParent();
                if (parent instanceof MainTableConfig) {
                    isFamily = mainConfigs.contains(parent.getTable().toLowerCase());
                    if (isFamily) continue;
                    mainConfigs.add(parent.getTable().toLowerCase());
                    continue;
                }
                if (!(parent instanceof ChildrenTableConfig) || !((grdParent = ((ChildrenTableConfig)parent).getParent()) instanceof MainTableConfig) || (isFamily = mainConfigs.contains(grdParent.getTable().toLowerCase()))) continue;
                mainConfigs.add(grdParent.getTable().toLowerCase());
            }
            if (mainConfigs.size() == 1 && isFamily && !joinSameConfig) {
                isWithJoin = false;
            }
        }
        return isWithJoin;
    }

    private static boolean withExistsXdb(StatementInfo stmtInfo, ShardingConfigProvider scp) {
        TableVisitor tv = TableVisitor.create();
        for (SQLExistsExpr existsExpr : stmtInfo.getExistsExprs()) {
            SQLSelect select = existsExpr.getSubQuery();
            select.accept((SQLASTVisitor)tv);
        }
        for (SQLExprTableSource exp : tv.getTableSources()) {
            String tableName = exp.getTableName();
            ShardingConfig tableConfig = scp.getConfig(tableName);
            if (tableConfig == null) continue;
            return true;
        }
        return false;
    }

    private static boolean simpleInSubQuery(StatementInfo stmtInfo, ShardingConfigProvider scp) {
        int shardTableCount = 0;
        TableInfo shardTableInfo = null;
        ShardingConfig shardConfig = null;
        for (TableInfo ti : stmtInfo.getTableInfos()) {
            shardConfig = scp.getConfig(ti.getName());
            if (shardConfig != null && shardConfig.isEnabled()) {
                ++shardTableCount;
                shardTableInfo = ti;
            }
            if (shardTableCount <= true) continue;
            return false;
        }
        if (shardConfig instanceof ChildrenTableConfig) {
            return false;
        }
        if (shardTableInfo == null) {
            return false;
        }
        SQLExprTableSource sqlObject = shardTableInfo.getSQLTableSource();
        while (!(sqlObject instanceof SQLSelect)) {
            sqlObject = sqlObject.getParent();
        }
        SQLSelect sqlSelect = (SQLSelect)sqlObject;
        SQLSelectQuery query = sqlSelect.getQuery();
        if (query instanceof SQLUnionQuery) {
            return false;
        }
        if (!(sqlSelect.getParent() instanceof SQLInSubQueryExpr)) {
            return false;
        }
        MergeFeatureVisitor mfvisitor = new MergeFeatureVisitor(sqlSelect);
        SelectFeature sf = mfvisitor.getSelectFeature();
        return !sf.hasGroupBy() && !sf.hasAggregate() && !sf.hasDistinct() && !sf.hasOrderBy() && !sf.hasLimit();
    }

    private static SQLExprTableSource getLeftJoinRootTableSource(SQLJoinTableSource tableSource) {
        if (tableSource.getLeft() instanceof SQLExprTableSource) {
            return (SQLExprTableSource)tableSource.getLeft();
        }
        return SpecUtil.getLeftJoinRootTableSource((SQLJoinTableSource)tableSource.getLeft());
    }

    private static SQLExprTableSource getRightJoinRootTableSource(SQLJoinTableSource tableSource) {
        if (tableSource.getRight() instanceof SQLExprTableSource) {
            return (SQLExprTableSource)tableSource.getRight();
        }
        return SpecUtil.getRightJoinRootTableSource((SQLJoinTableSource)tableSource.getRight());
    }

    private static void collectLeftJoinTableSource(SQLJoinTableSource tableSource, List<SQLJoinTableSource> joinTableSources) {
        if (tableSource.getLeft() instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinTableSource = (SQLJoinTableSource)tableSource.getLeft();
            joinTableSources.add(joinTableSource);
            SpecUtil.collectLeftJoinTableSource(joinTableSource, joinTableSources);
        }
    }

    private static void collectRightJoinTableSource(SQLJoinTableSource tableSource, List<SQLJoinTableSource> joinTableSources) {
        if (tableSource.getRight() instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinTableSource = (SQLJoinTableSource)tableSource.getRight();
            joinTableSources.add(joinTableSource);
            SpecUtil.collectRightJoinTableSource(joinTableSource, joinTableSources);
        }
    }
}

