/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.engine.spec.join;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionOperator;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.engine.StatementShardingEngine;
import kd.bos.xdb.engine.spec.SelfSharding;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.merge.feature.MergeFeatureVisitor;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.bos.xdb.sharding.sql.FinalShardingSQL;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.StatementType;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.sharding.sql.visitor.SQLIdentifierVisitor;
import kd.bos.xdb.sharding.sql.visitor.SQLPropertyVisitor;
import kd.bos.xdb.sharding.sql.visitor.TableVisitor;
import kd.bos.xdb.sharding.sql.visitor.mysql.MySqlTableVisitor;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.xpm.metrics.action.sharding.spec.JoinSpan;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class ShardingJoin
implements SelfSharding {
    private final StatementInfo stmtInfo;
    private final ShardingConfigProvider scp;

    public ShardingJoin(StatementInfo stmtInfo, ShardingConfigProvider scp) {
        this.stmtInfo = stmtInfo;
        this.scp = scp;
    }

    @Override
    public ShardingResult sharding(StatementShardingEngine shardingEngine, ShardingContext ctx) {
        MetricsCollector mc;
        MergeFeatureVisitor mfvisitor;
        MySqlTableVisitor tv = new MySqlTableVisitor();
        ArrayList<SQLJoinTableSource> joinTableSources = new ArrayList<SQLJoinTableSource>(10);
        for (SQLJoinTableSource joinTableInfo : this.stmtInfo.getJoinTableInfos()) {
            joinTableSources.add(joinTableInfo);
            if (joinTableInfo.getJoinType().name.equals(SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN.name)) {
                this.collectLeftJoinTableSource(joinTableInfo, joinTableSources);
                continue;
            }
            if (!joinTableInfo.getJoinType().name.equals(SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN.name)) continue;
            this.collectRightJoinTableSource(joinTableInfo, joinTableSources);
        }
        for (SQLJoinTableSource joinTableInfo : joinTableSources) {
            SQLTableSource tableSource = null;
            if (joinTableInfo.getJoinType().name.equals(SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN.name)) {
                tableSource = joinTableInfo.getRight();
            } else if (joinTableInfo.getJoinType().name.equals(SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN.name)) {
                tableSource = joinTableInfo.getLeft();
            }
            if (null == tableSource) continue;
            tableSource.accept((SQLASTVisitor)tv);
        }
        for (SQLExistsExpr existsExpr : this.stmtInfo.getExistsExprs()) {
            SQLSelect select = existsExpr.getSubQuery();
            select.accept((SQLASTVisitor)tv);
        }
        for (SQLExprTableSource exprTableSource : tv.getTableSources()) {
            String[] sdTables;
            String tableName = exprTableSource.getTableName();
            ShardingConfig tableConfig = this.scp.getConfig(tableName);
            if (null == tableConfig || !tableConfig.isEnabled()) continue;
            SQLObject parent = exprTableSource.getParent();
            List<HintCondition> conditionList = null;
            if (parent instanceof MySqlSelectQueryBlock) {
                sdTables = tableConfig.getShardingStrategy().getAllShardingTablesUseHintContext(true);
            } else {
                ShardingSQL[] sqls = shardingEngine.sharding(this.stmtInfo, false);
                HashSet<Long> indexs = new HashSet<Long>(sqls.length);
                boolean isPrototype = false;
                String originalName = TableName.of(tableName).getOriginalName();
                for (ShardingSQL sql : sqls) {
                    List<TableInfo> tableInfos = sql.getStatementInfo().getTableInfos();
                    for (TableInfo tableInfo : tableInfos) {
                        String tName = tableInfo.getSQLTableSource().getTableName();
                        TableName of = TableName.of(tName);
                        if (!originalName.equalsIgnoreCase(of.getOriginalName())) continue;
                        if (of.isPrototypeTable()) {
                            isPrototype = true;
                            continue;
                        }
                        indexs.add(of.getShardingIndex());
                    }
                }
                ArrayList<String> shardingTables = new ArrayList<String>(indexs.size());
                for (Long index : indexs) {
                    shardingTables.add(TableName.of(tableName).getShardingTable(index));
                }
                if (isPrototype && shardingTables.size() == 0) {
                    shardingTables.add(TableName.of(tableName).getPrototypeTable());
                }
                sdTables = shardingTables.toArray(new String[shardingTables.size()]);
                ShardingHintContext hintContext = ShardingHintContext.get();
                if (!isPrototype && hintContext != null && !hintContext.isSkipHint()) {
                    conditionList = hintContext.effectiveHintCondition(tableConfig);
                }
            }
            if (sdTables.length == 0) {
                sdTables = new String[]{TableName.of(tableName).getPrototypeTable()};
            }
            SQLSubqueryTableSource subqueryTableSource = this.splicedSubqueryTableSource(exprTableSource, sdTables, conditionList);
            if (parent instanceof MySqlSelectQueryBlock) {
                ((MySqlSelectQueryBlock)parent).setFrom((SQLTableSource)subqueryTableSource);
                continue;
            }
            if (!(parent instanceof SQLJoinTableSource)) continue;
            if (exprTableSource == ((SQLJoinTableSource)parent).getLeft()) {
                ((SQLJoinTableSource)parent).setLeft((SQLTableSource)subqueryTableSource);
                continue;
            }
            ((SQLJoinTableSource)parent).setRight((SQLTableSource)subqueryTableSource);
        }
        SQLSelectStatement subStmt = new SQLSelectStatement(((SQLSelectStatement)this.stmtInfo.getSQLStatement()).getSelect());
        String sql = subStmt.toString();
        Object[] params = this.stmtInfo.getSQLInfo().getParams();
        Object[] subParams = new Object[params.length];
        System.arraycopy(params, 0, subParams, 0, params.length);
        StatementInfo stmt = new StatementInfo(new SQLInfo(sql, subParams, true), (SQLStatement)subStmt);
        SelectFeature sf = null;
        if (stmt.getStatementType() == StatementType.select && (sf = (mfvisitor = new MergeFeatureVisitor((SQLSelectStatement)stmt.getSQLStatement())).getSelectFeature()).hasLimit()) {
            stmt.getSQLInfo().setSql(stmt.getSQLStatement().toString());
        }
        if ((mc = MetricsCollector.getCurrent()).isActionMetricEnabled()) {
            mc.actionMetric().stat(new JoinSpan(stmt.getSQLInfo().getSql()));
        }
        ShardingSQL[] sss = shardingEngine.sharding(stmt, true);
        SQLInfo[] ret = new SQLInfo[sss.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = FinalShardingSQL.finallyShardingSQL(sss[i]);
        }
        for (SQLExprTableSource exprTableSource : tv.getTableSources()) {
            String tableName = exprTableSource.getTableName();
            ShardingConfig tableConfig = this.scp.getConfig(tableName);
            if (null == tableConfig || !tableConfig.isEnabled()) continue;
            SQLObject parent = exprTableSource.getParent();
            if (parent instanceof MySqlSelectQueryBlock) {
                ((MySqlSelectQueryBlock)parent).setFrom((SQLTableSource)exprTableSource);
                continue;
            }
            if (!(parent instanceof SQLJoinTableSource)) continue;
            if (exprTableSource == ((SQLJoinTableSource)parent).getLeft()) {
                ((SQLJoinTableSource)parent).setLeft((SQLTableSource)exprTableSource);
                continue;
            }
            ((SQLJoinTableSource)parent).setRight((SQLTableSource)exprTableSource);
        }
        return ShardingResult.shardingResult(ret, this.stmtInfo, sf);
    }

    private static MySqlSelectQueryBlock extrackSelectBlock(SQLObject tableSource) {
        SQLObject parent = tableSource.getParent();
        if (parent instanceof MySqlSelectQueryBlock) {
            return (MySqlSelectQueryBlock)parent;
        }
        return ShardingJoin.extrackSelectBlock(parent);
    }

    private SQLSubqueryTableSource splicedSubqueryTableSource(SQLExprTableSource tableSource, String[] sdTables, List<HintCondition> conditionList) {
        MySqlSelectQueryBlock sqlSelectQueryBlock = ShardingJoin.extrackSelectBlock((SQLObject)tableSource);
        String tab = null != tableSource.getAlias() ? tableSource.getAlias() : tableSource.getExpr().toString();
        HashSet<SQLSelectItem> sdSelectItems = new HashSet<SQLSelectItem>();
        SQLPropertyVisitor propertyVisitor = new SQLPropertyVisitor();
        sqlSelectQueryBlock.accept((SQLASTVisitor)((Object)propertyVisitor));
        for (SQLPropertyExpr sQLPropertyExpr : propertyVisitor.getSqlPropertyExprList()) {
            if (!sQLPropertyExpr.getOwnerName().equals(tab)) continue;
            SQLSelectItem item = new SQLSelectItem();
            item.setExpr((SQLExpr)new SQLIdentifierExpr(sQLPropertyExpr.getName()));
            sdSelectItems.add(item);
        }
        SQLIdentifierVisitor identifierVisitor = new SQLIdentifierVisitor();
        sqlSelectQueryBlock.accept((SQLASTVisitor)((Object)identifierVisitor));
        for (SQLIdentifierExpr identifierExpr : identifierVisitor.getIdentifierExprList()) {
            if (identifierExpr.getResolvedTableSource() != tableSource) continue;
            SQLSelectItem item = new SQLSelectItem();
            item.setExpr((SQLExpr)new SQLIdentifierExpr(identifierExpr.getName()));
            sdSelectItems.add(item);
        }
        SQLSelectStatement sQLSelectStatement = this.splicedOrgSelect(sdSelectItems, (SQLTableSource)tableSource, conditionList);
        SQLSubqueryTableSource subqueryTableSource = new SQLSubqueryTableSource();
        if (sdTables.length == 1) {
            SQLSelectQueryBlock selectQueryBlock = this.spliceSelectQueryBlock((SQLStatement)sQLSelectStatement, sdTables[0]);
            subqueryTableSource.setSelect(new SQLSelect((SQLSelectQuery)selectQueryBlock));
        } else {
            SQLUnionQuery unionQuery = this.splicedUnionQuery((SQLStatement)sQLSelectStatement, sdTables);
            subqueryTableSource.setSelect(new SQLSelect((SQLSelectQuery)unionQuery));
        }
        subqueryTableSource.setAlias(tab);
        return subqueryTableSource;
    }

    private SQLSubqueryTableSource splicedSubqueryTableSource(SQLSelectStatement selectStatement, SQLExprTableSource tableSource, String[] sdTables) {
        SQLPropertyVisitor propertyVisitor = new SQLPropertyVisitor();
        selectStatement.accept((SQLASTVisitor)((Object)propertyVisitor));
        String tab = null != tableSource.getAlias() ? tableSource.getAlias() : tableSource.getExpr().toString();
        HashSet<SQLSelectItem> sdSelectItems = new HashSet<SQLSelectItem>();
        for (SQLPropertyExpr propertyExpr : propertyVisitor.getSqlPropertyExprList()) {
            if (!propertyExpr.getOwnerName().equals(tab)) continue;
            SQLSelectItem item = new SQLSelectItem();
            item.setExpr((SQLExpr)new SQLIdentifierExpr(propertyExpr.getName()));
            sdSelectItems.add(item);
        }
        SQLSelectStatement orgSelectStatement = this.splicedOrgSelect(sdSelectItems, (SQLTableSource)tableSource, null);
        SQLSubqueryTableSource subqueryTableSource = new SQLSubqueryTableSource();
        subqueryTableSource.setAlias(tab);
        if (sdTables.length == 1) {
            SQLSelectQueryBlock sqlSelectQueryBlock = this.spliceSelectQueryBlock((SQLStatement)orgSelectStatement, sdTables[0]);
            subqueryTableSource.setSelect(new SQLSelect((SQLSelectQuery)sqlSelectQueryBlock));
        } else {
            SQLUnionQuery unionQuery = this.splicedUnionQuery((SQLStatement)orgSelectStatement, sdTables);
            subqueryTableSource.setSelect(new SQLSelect((SQLSelectQuery)unionQuery));
        }
        return subqueryTableSource;
    }

    private SQLSelectStatement splicedOrgSelect(Set<SQLSelectItem> sdSelectItems, SQLTableSource tabSource, List<HintCondition> conditionList) {
        SQLSelectStatement sqlSelectStatement = new SQLSelectStatement();
        SQLSelectQueryBlock queryBlock = new SQLSelectQueryBlock();
        queryBlock.setFrom(tabSource.clone());
        for (SQLSelectItem item : sdSelectItems) {
            queryBlock.addSelectItem(item);
        }
        if (conditionList != null) {
            ArrayList<SQLExpr> exprList = new ArrayList<SQLExpr>(conditionList.size());
            block15: for (HintCondition c : conditionList) {
                Object right;
                String field = c.getField();
                FilterType ft = c.getFilterType();
                Object[] value = c.getValue();
                if (value == null) continue;
                SQLPropertyExpr left = new SQLPropertyExpr(((SQLExprTableSource)tabSource).getAlias(), field);
                left.setResolvedTableSource(tabSource);
                SQLBinaryOperator operator = null;
                boolean isIn = false;
                switch (ft) {
                    case between_and: {
                        break;
                    }
                    case not_between_and: {
                        break;
                    }
                    case in_range: {
                        isIn = true;
                        if (value instanceof Collection) {
                            value = ((Collection)value).toArray();
                        } else if (value instanceof Iterable) {
                            ArrayList list = new ArrayList();
                            Iterator iter = ((Iterable)value).iterator();
                            while (iter.hasNext()) {
                                list.add(iter.next());
                            }
                            value = list.toArray();
                        }
                        int len = Array.getLength(value);
                        ArrayList<SQLCharExpr> inList = new ArrayList<SQLCharExpr>(len);
                        for (int j = 0; j < len; ++j) {
                            SQLCharExpr right2;
                            Object temp = Array.get(value, j);
                            if (temp instanceof String) {
                                right2 = new SQLCharExpr((String)temp);
                            } else if (temp instanceof Integer) {
                                right2 = new SQLIntegerExpr((Number)temp);
                            } else if (temp instanceof Long) {
                                right2 = new SQLIntegerExpr((Number)new BigInteger(temp.toString()));
                            } else {
                                if (!(temp instanceof Number)) break;
                                right2 = new SQLNumberExpr((Number)temp);
                            }
                            inList.add(right2);
                        }
                        if (inList.size() <= 0) break;
                        if (inList.size() == 1) {
                            operator = SQLBinaryOperator.Equality;
                            SQLBinaryOpExpr opExpr = new SQLBinaryOpExpr((SQLExpr)left, operator, (SQLExpr)inList.get(0));
                            exprList.add((SQLExpr)opExpr);
                            break;
                        }
                        SQLInListExpr inListExpr = new SQLInListExpr((SQLExpr)left);
                        inListExpr.setTargetList(inList);
                        exprList.add((SQLExpr)inListExpr);
                        break;
                    }
                    case not_in_range: {
                        break;
                    }
                    case eq: {
                        operator = SQLBinaryOperator.Equality;
                        break;
                    }
                    case ge: {
                        operator = SQLBinaryOperator.GreaterThanOrEqual;
                        break;
                    }
                    case gt: {
                        operator = SQLBinaryOperator.GreaterThan;
                        break;
                    }
                    case le: {
                        operator = SQLBinaryOperator.LessThanOrEqual;
                        break;
                    }
                    case like: {
                        operator = SQLBinaryOperator.Like;
                        break;
                    }
                    case lt: {
                        operator = SQLBinaryOperator.LessThan;
                        break;
                    }
                    case not_eq: {
                        operator = SQLBinaryOperator.NotEqual;
                        break;
                    }
                    case not_like: {
                        operator = SQLBinaryOperator.NotLike;
                        break;
                    }
                    default: {
                        continue block15;
                    }
                }
                if (isIn || operator == null || (right = value instanceof String ? new SQLCharExpr((String)value) : (value instanceof Integer ? new SQLIntegerExpr((Number)value) : (value instanceof Long ? new SQLIntegerExpr((Number)new BigInteger(value.toString())) : (value instanceof Number ? new SQLNumberExpr((Number)value) : null)))) == null) continue;
                SQLBinaryOpExpr opExpr = new SQLBinaryOpExpr((SQLExpr)left, operator, (SQLExpr)right);
                exprList.add((SQLExpr)opExpr);
            }
            if (!exprList.isEmpty()) {
                queryBlock.setWhere((SQLExpr)(exprList.size() == 1 ? (SQLExpr)exprList.get(0) : this.doSplicedBinaryOpExpr(exprList)));
            }
        }
        sqlSelectStatement.setSelect(new SQLSelect((SQLSelectQuery)queryBlock));
        return sqlSelectStatement;
    }

    private SQLBinaryOpExpr doSplicedBinaryOpExpr(List<SQLExpr> exprList) {
        if (exprList.size() == 2) {
            SQLExpr left = exprList.get(0);
            SQLExpr right = exprList.get(1);
            return new SQLBinaryOpExpr(left, SQLBinaryOperator.BooleanAnd, right);
        }
        return new SQLBinaryOpExpr(exprList.get(exprList.size() - 1), SQLBinaryOperator.BooleanAnd, (SQLExpr)this.doSplicedBinaryOpExpr(exprList.subList(0, exprList.size() - 1)));
    }

    private SQLUnionQuery splicedUnionQuery(SQLStatement stmt, String[] sdTables) {
        TableVisitor tv = TableVisitor.create();
        stmt.accept((SQLASTVisitor)tv);
        SQLExpr orgExpr = tv.getTableSources().get(0).getExpr();
        ArrayList<SQLSelectQueryBlock> sdSql = new ArrayList<SQLSelectQueryBlock>();
        if (stmt instanceof SQLSelectStatement) {
            for (String tb : sdTables) {
                tv.getTableSources().get(0).setExpr(tb);
                SQLSelectQueryBlock selectQueryBlock = ((SQLSelectStatement)stmt).getSelect().getQueryBlock().clone();
                sdSql.add(selectQueryBlock);
                tv.getTableSources().get(0).setExpr(orgExpr);
            }
        }
        return this.doSplicedUnion(sdSql);
    }

    private SQLSelectQueryBlock spliceSelectQueryBlock(SQLStatement stmt, String sdTable) {
        TableVisitor tv = TableVisitor.create();
        stmt.accept((SQLASTVisitor)tv);
        SQLExpr orgExpr = tv.getTableSources().get(0).getExpr();
        tv.getTableSources().get(0).setExpr(sdTable);
        SQLSelectQueryBlock selectQueryBlock = ((SQLSelectStatement)stmt).getSelect().getQueryBlock().clone();
        tv.getTableSources().get(0).setExpr(orgExpr);
        return selectQueryBlock;
    }

    private SQLUnionQuery doSplicedUnion(List<SQLSelectQueryBlock> sdSelects) {
        if (sdSelects.size() == 2) {
            SQLUnionQuery unionQuery = new SQLUnionQuery();
            SQLSelectQueryBlock leftSelect = sdSelects.get(0);
            unionQuery.setLeft((SQLSelectQuery)leftSelect);
            SQLSelectQueryBlock rightSelect = sdSelects.get(1);
            unionQuery.setRight((SQLSelectQuery)rightSelect);
            unionQuery.setOperator(SQLUnionOperator.UNION_ALL);
            return unionQuery;
        }
        SQLUnionQuery unionQuery = new SQLUnionQuery();
        SQLUnionQuery leftQuery = this.doSplicedUnion(sdSelects.subList(0, sdSelects.size() - 1));
        unionQuery.setLeft((SQLSelectQuery)leftQuery);
        SQLSelectQueryBlock rightSelect = sdSelects.get(sdSelects.size() - 1);
        unionQuery.setRight((SQLSelectQuery)rightSelect);
        unionQuery.setOperator(SQLUnionOperator.UNION_ALL);
        return unionQuery;
    }

    private void collectLeftJoinTableSource(SQLJoinTableSource tableSource, List<SQLJoinTableSource> joinTableSources) {
        if (tableSource.getLeft() instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinTableSource = (SQLJoinTableSource)tableSource.getLeft();
            joinTableSources.add(joinTableSource);
            this.collectLeftJoinTableSource(joinTableSource, joinTableSources);
        }
    }

    private void collectRightJoinTableSource(SQLJoinTableSource tableSource, List<SQLJoinTableSource> joinTableSources) {
        if (tableSource.getRight() instanceof SQLJoinTableSource) {
            SQLJoinTableSource joinTableSource = (SQLJoinTableSource)tableSource.getRight();
            joinTableSources.add(joinTableSource);
            this.collectRightJoinTableSource(joinTableSource, joinTableSources);
        }
    }
}

