/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.engine.spec.subquery;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.xdb.engine.ShardingContext;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.engine.StatementShardingEngine;
import kd.bos.xdb.engine.spec.SelfSharding;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.sharding.ShardingGroupTable;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.sharding.sql.FinalShardingSQL;
import kd.bos.xdb.sharding.sql.ParamsGroup;
import kd.bos.xdb.sharding.sql.SQLInfo;
import kd.bos.xdb.sharding.sql.ShardingSQL;
import kd.bos.xdb.sharding.sql.condition.ConditionShardingSQL;
import kd.bos.xdb.sharding.sql.parser.ConditionInfo;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;

public class SimpleInSubQuery
implements SelfSharding {
    private final StatementInfo stmtInfo;
    private final ShardingConfigProvider scp;
    private final SelectFeature sf;

    public SimpleInSubQuery(StatementInfo stmtInfo, ShardingConfigProvider scp, SelectFeature sf) {
        this.stmtInfo = stmtInfo;
        this.scp = scp;
        this.sf = sf;
    }

    @Override
    public ShardingResult sharding(StatementShardingEngine shardingEngine, ShardingContext ctx) {
        ShardingSQL[] sss;
        TableInfo shardTableInfo = null;
        for (TableInfo ti : this.stmtInfo.getTableInfos()) {
            ShardingConfig tableConfig = this.scp.getConfig(ti.getName());
            if (tableConfig == null || !tableConfig.isEnabled()) continue;
            shardTableInfo = ti;
            break;
        }
        if (shardTableInfo != null) {
            ArrayList<List<Object>> params = new ArrayList<List<Object>>(1);
            ConditionShardingSQL originalShardingSQL = (ConditionShardingSQL)this.stmtInfo.shardingSQL();
            ConditionShardingSQL.Pair<ParamsGroup, List<ConditionInfo>> pair = originalShardingSQL.paramsGroup();
            for (Map.Entry<ParamsGroup.ParameterKey, List<Object>> parameterKeyListEntry : pair.getKey().getParamMap().entrySet()) {
                SQLExprTableSource owner;
                ParamsGroup.ParameterKey parameterKey = parameterKeyListEntry.getKey();
                if (!(parameterKey.getOwner() instanceof SQLExprTableSource) || (owner = (SQLExprTableSource)parameterKey.getOwner()) != shardTableInfo.getSQLTableSource()) continue;
                params.add(parameterKeyListEntry.getValue());
            }
            SQLExprTableSource sqlObject = shardTableInfo.getSQLTableSource();
            while (!(sqlObject instanceof SQLSelect)) {
                sqlObject = sqlObject.getParent();
            }
            SQLSelect sqlSelect = (SQLSelect)sqlObject;
            SQLSelectStatement newStmt = new SQLSelectStatement(sqlSelect);
            String sql = newStmt.toString();
            StatementInfo newStmtInfo = new StatementInfo(new SQLInfo(sql, params.toArray(), true), (SQLStatement)newStmt);
            ShardingSQL[] nss = shardingEngine.sharding(newStmtInfo, true);
            ShardingGroupTable[] groups = new ShardingGroupTable[nss.length];
            int k = 0;
            for (ShardingSQL shardingSQL : nss) {
                ShardingGroupTable group = new ShardingGroupTable(shardingSQL.getShardingTables().get(0));
                groups[k++] = group;
            }
            sss = originalShardingSQL.sharding(shardTableInfo, pair.getValue(), groups);
        } else {
            sss = shardingEngine.sharding(this.stmtInfo, true);
        }
        SQLInfo[] ret = new SQLInfo[sss.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = FinalShardingSQL.finallyShardingSQL(sss[i]);
        }
        return ShardingResult.shardingResult(ret, this.stmtInfo, this.sf);
    }
}

