/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.eventbus;

import java.lang.reflect.Method;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLogable;
import kd.bos.xdb.eventbus.RequestContextInfo;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.sql.dml.update.ShardingDataMoveCommittedEvent;

public class UpdateClusterCacheNotify
implements XDBLogable {
    private static Class<?> broadcastClass;
    private static Method broadcastMessage;
    private static Log logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateCache(ShardingDataMoveCommittedEvent event) {
        try (AutoCloseable ac = event.getRequestContextInfo().setupThreadRequestContext();){
            ShardingConfig config = XDBConfig.getShardingConfigProvider().getConfig(event.getMainTable());
            if (config != null) {
                config.getShardingStrategy().onShardingDataMoveCommitted(event.getShardingDataMoveMetaList(), true);
            }
        }
        catch (Exception e) {
            log.error("updateCache event " + event.getClass().getName() + " error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            ThreadLocals.release();
        }
    }

    public static void notify(ShardingDataMoveCommittedEvent event) {
        if (broadcastMessage != null) {
            try {
                event.setRequestContextInfo(RequestContextInfo.get());
                broadcastMessage.invoke(broadcastClass, UpdateClusterCacheNotify.class.getName(), "updateCache", new Object[]{event});
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"broadcast message error"});
            }
        }
    }

    static {
        logger = LogFactory.getLog(UpdateClusterCacheNotify.class);
        try {
            Method[] methods;
            broadcastClass = Class.forName("kd.bos.mq.broadcast.BroadcastService");
            for (Method m : methods = broadcastClass.getDeclaredMethods()) {
                if (!m.getName().equals("broadcastMessage")) continue;
                broadcastMessage = m;
                break;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

