/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.eventbus.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.xdb.eventbus.StoreBase;

public class DBStore
extends StoreBase {
    private final int timeout;
    private final DistributeSessionlessCache dbCacheAdapter;

    public DBStore(String keyPrefix) {
        this(keyPrefix, 36000);
    }

    public DBStore(String keyPrefix, int timeoutSeconds) {
        super(keyPrefix);
        this.timeout = timeoutSeconds;
        DistributeCacheHAPolicy distributeCacheHAPolicy = new DistributeCacheHAPolicy();
        distributeCacheHAPolicy.setTenantable(false);
        distributeCacheHAPolicy.setDbBackup(true);
        this.dbCacheAdapter = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("XDB-EventBus-Store", distributeCacheHAPolicy);
    }

    private String encodeDBKey(String key) {
        return new String(this.encodeKey(key));
    }

    private String decodeDBKey(String decodeValue) {
        return this.decodeKey(decodeValue.getBytes());
    }

    private String encodeBytes(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private byte[] decodeString(String value) {
        return Base64.getDecoder().decode(value);
    }

    @Override
    public <T> T get(String key) {
        String value = (String)this.dbCacheAdapter.get(this.encodeDBKey(key));
        return (T)this.decode(this.decodeString(value));
    }

    @Override
    public <T> void set(String key, T value) {
        this.dbCacheAdapter.put(this.encodeDBKey(key), (Object)this.encodeBytes(this.encode(value)), this.timeout);
    }

    @Override
    public <T> void set(String key, T value, int expire) {
        this.dbCacheAdapter.put(this.encodeDBKey(key), (Object)this.encodeBytes(this.encode(value)), expire);
    }

    @Override
    public void setInc(String key, long value) {
        this.dbCacheAdapter.put(this.encodeDBKey(key), (Object)String.valueOf(value), this.timeout);
    }

    @Override
    public long inc(String key, long inc) {
        return this.inc(key, inc, this.timeout);
    }

    @Override
    public long inc(String key, long inc, int timeout) {
        String encodeDBKey = this.encodeDBKey(key);
        long c = this.dbCacheAdapter.incrBy(encodeDBKey, (int)inc);
        this.dbCacheAdapter.expireAfter(encodeDBKey, timeout, TimeUnit.SECONDS);
        return c;
    }

    @Override
    public long getInc(String key) {
        String value = (String)this.dbCacheAdapter.get(this.encodeDBKey(key));
        if (value == null || value.length() == 0) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    @Override
    public void remove(String key) {
        this.dbCacheAdapter.remove(this.encodeDBKey(key));
    }

    @Override
    public <T> void mapSet(String type, String field, T value) {
        String key = this.encodeDBKey(type);
        Map all = this.dbCacheAdapter.getAll(key);
        all.put(this.encodeDBKey(field), this.encodeBytes(this.encode(value)));
        this.dbCacheAdapter.put(key, all);
        this.dbCacheAdapter.expireAfter(key, this.timeout);
    }

    @Override
    public <T> void mapMSet(String type, Map<String, T> valueMap) {
        String encodeDBType = this.encodeDBKey(type);
        HashMap<String, String> map = new HashMap<String, String>(256);
        int size = 0;
        for (Map.Entry<String, T> entry : valueMap.entrySet()) {
            String key = this.encodeDBKey(entry.getKey());
            String value = this.encodeBytes(this.encode(entry.getValue()));
            map.put(key, value);
            if ((size += key.length() + value.length()) < 0x100000) continue;
            this.dbCacheAdapter.put(encodeDBType, map);
            map.clear();
            size = 0;
        }
        if (!map.isEmpty()) {
            this.dbCacheAdapter.put(encodeDBType, map);
        }
        this.dbCacheAdapter.expireAfter(encodeDBType, this.timeout);
    }

    @Override
    public <T> T mapGet(String type, String field) {
        Map all = this.dbCacheAdapter.getAll(this.encodeDBKey(type));
        String value = (String)all.get(this.encodeDBKey(field));
        return (T)this.decode(this.decodeString(value));
    }

    @Override
    public <T> Map<String, T> mapMGet(String type, String ... fields) {
        HashMap<String, Object> ret = new HashMap<String, Object>(fields.length);
        List<String> encodeKeyFields = Arrays.asList(fields).stream().map(s -> this.encodeDBKey((String)s)).collect(Collectors.toList());
        List values = this.dbCacheAdapter.get(this.encodeDBKey(type), encodeKeyFields.toArray(new String[encodeKeyFields.size()]));
        int i = 0;
        for (String field : fields) {
            ret.put(field, this.decode(this.decodeString((String)values.get(i++))));
        }
        return ret;
    }

    @Override
    public long mapInc(String type, String field, long v) {
        String encodeField;
        String encodeType = this.encodeDBKey(type);
        String value = (String)this.dbCacheAdapter.get(encodeType, encodeField = this.encodeDBKey(field));
        if (value == null) {
            value = "0";
        }
        v = Long.parseLong(value) + v;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(encodeField, String.valueOf(v));
        this.dbCacheAdapter.put(encodeType, map);
        this.dbCacheAdapter.expireAfter(encodeType, this.timeout);
        return v;
    }

    @Override
    public long mapGetInc(String type, String field) {
        String encodeField;
        String encodeType = this.encodeDBKey(type);
        String value = (String)this.dbCacheAdapter.get(encodeType, encodeField = this.encodeDBKey(field));
        if (value == null) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    @Override
    public <T> Map<String, T> mapGetAll(String type) {
        Map all = this.dbCacheAdapter.getAll(this.encodeDBKey(type));
        if (all.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap ret = new HashMap(all.size());
        all.forEach((k, v) -> ret.put(this.decodeDBKey((String)k), this.decode(this.decodeString((String)v))));
        return ret;
    }

    @Override
    public Map<String, Long> mapGetAllInc(String type) {
        Map all = this.dbCacheAdapter.getAll(this.encodeDBKey(type));
        if (all.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> ret = new HashMap<String, Long>(all.size());
        all.forEach((k, v) -> ret.put(this.decodeDBKey((String)k), Long.parseLong(v)));
        return ret;
    }

    @Override
    public int mapSize(String type) {
        return this.dbCacheAdapter.getAll(this.encodeDBKey(type)).size();
    }

    @Override
    public void mapRemove(String type, String field) {
        this.dbCacheAdapter.remove(this.encodeDBKey(type), this.encodeDBKey(field));
    }

    @Override
    public <T> void listAddLast(String key, T value) {
        String[] values = this.dbCacheAdapter.getList(this.encodeDBKey(key));
        String[] addValues = new String[values.length + 1];
        System.arraycopy(values, 0, addValues, 0, values.length);
        addValues[values.length] = this.encodeBytes(this.encode(value));
        this.dbCacheAdapter.addList(this.encodeDBKey(key), addValues);
    }

    @Override
    public <T> void listAddFirst(String key, T value) {
        String[] values = this.dbCacheAdapter.getList(this.encodeDBKey(key));
        String[] addValues = new String[values.length + 1];
        System.arraycopy(values, 0, addValues, 1, values.length);
        addValues[0] = this.encodeBytes(this.encode(value));
        this.dbCacheAdapter.addList(this.encodeDBKey(key), addValues);
    }

    @Override
    public <T> List<T> listGetAll(String key) {
        String[] values = this.dbCacheAdapter.getList(this.encodeDBKey(key));
        return Arrays.asList(values).stream().map(v -> this.decode(this.decodeString((String)v))).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> listGetRange(String key, int fromIndex, int toIndex) {
        String[] values = this.dbCacheAdapter.getList(this.encodeDBKey(key));
        int length = values.length;
        if (fromIndex < 0 || fromIndex > toIndex || fromIndex >= length || toIndex >= length) {
            throw new KDException(BosErrorCode.paramError, new Object[]{String.format("DBStore listGetRange invalid range from index %s to index %s", fromIndex, toIndex)});
        }
        int range = toIndex - fromIndex;
        ArrayList<Object> ret = new ArrayList<Object>(range);
        for (int i = fromIndex; i < toIndex; ++i) {
            ret.add(this.decode(this.decodeString(values[i])));
        }
        return ret;
    }

    @Override
    public int listSize(String key) {
        return this.dbCacheAdapter.getListLength(this.encodeDBKey(key));
    }

    @Override
    public <T> void listRemove(String key, T value) {
        String encodeValue = this.encodeBytes(this.encode(value));
        String[] list = this.dbCacheAdapter.getList(this.encodeDBKey(key));
        List<String> toRemoveList = Arrays.asList(list);
        toRemoveList.remove(encodeValue);
        this.dbCacheAdapter.addList(this.encodeDBKey(key), toRemoveList.toArray(new String[toRemoveList.size()]));
    }

    @Override
    public <T> boolean listContains(String key, T value) {
        String encodeValue = this.encodeBytes(this.encode(value));
        String[] list = this.dbCacheAdapter.getList(this.encodeDBKey(key));
        return Arrays.asList(list).contains(encodeValue);
    }

    @Override
    public <T> T listGetFirst(String key) {
        String[] values = this.dbCacheAdapter.getList(this.encodeDBKey(key));
        if (values.length == 0) {
            return null;
        }
        return (T)this.decode(this.decodeString(values[0]));
    }
}

