/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.ext;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kd.bos.util.ThreadLocals;
import kd.bos.xdb.ParallelConnectionHolder;
import kd.bos.xdb.ParallelExecuteContext;
import kd.bos.xdb.cache.Cache;
import kd.bos.xdb.cache.CacheContext;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.ext.ExtContextThreadCloser;
import kd.bos.xdb.ext.ExtInit;
import kd.bos.xdb.temptable.pk.PKTempTableHint;

public class ExtContext {
    private static final ThreadLocal<ExtContext> th = ThreadLocals.create();
    private final String dbRoute;
    private final ParallelConnectionHolder connectionHolder;
    private final DBType dbType;
    private List<Statement> statements = new CopyOnWriteArrayList<Statement>();
    private ParallelExecuteContext pec;
    private ExtContext parent;

    public static ExtContext get() {
        return th.get();
    }

    public static ParallelExecuteContext getParallelExecuteContext() {
        ExtContext ctx = ExtContext.get();
        return ctx == null ? null : ctx.pec;
    }

    public static boolean useArchiveRoute() {
        ExtContext ctx = ExtContext.get();
        if (ctx != null && ctx.pec != null) {
            return ctx.pec.useArchiveRoute(ctx.dbRoute);
        }
        return false;
    }

    public static boolean writtenInTX(String querySQL) {
        ExtContext ctx = ExtContext.get();
        if (ctx != null && ctx.pec != null) {
            return ctx.pec.writtenInTX(ctx.dbRoute, querySQL);
        }
        return true;
    }

    public ExtContext(String dbRoute, ParallelConnectionHolder connectionHolder, final ParallelExecuteContext pec) {
        this.dbRoute = dbRoute;
        this.connectionHolder = connectionHolder;
        this.dbType = connectionHolder.getDBType();
        final PKTempTableHint hint = PKTempTableHint.get();
        if (pec != null || hint != null) {
            this.pec = new ParallelExecuteContext(){
                private ExtContextThreadCloser closer = null;
                private PKTempTableHint newHint = null;

                @Override
                public void init() {
                    if (pec != null) {
                        pec.init();
                    }
                }

                @Override
                public void setup() {
                    if (pec != null) {
                        pec.setup();
                    }
                    this.closer = ExtContext.this.setupThread();
                    if (hint != null) {
                        this.newHint = PKTempTableHint.threshold(hint.getThreshold());
                    }
                }

                @Override
                public void clear() {
                    if (this.newHint != null) {
                        this.newHint.close();
                    }
                    this.closer.close();
                    if (pec != null) {
                        pec.clear();
                    }
                }

                @Override
                public boolean useArchiveRoute(String dbRoute) {
                    return pec == null ? false : pec.useArchiveRoute(dbRoute);
                }

                @Override
                public boolean writtenInTX(String dbRoute, String querySQL) {
                    return pec == null ? true : pec.writtenInTX(dbRoute, querySQL);
                }
            };
            this.pec.init();
        }
    }

    public ExtContextThreadCloser setupThread() {
        return this.setupThread(false);
    }

    public ExtContextThreadCloser setupThread(boolean reuse) {
        this.parent = th.get();
        th.set(this);
        Cache executorCache = null;
        if (!reuse || CacheContext.get().getCurrentCache() == null) {
            executorCache = CacheContext.get().createExecutorCache();
        }
        final Cache cache = executorCache;
        return new ExtContextThreadCloser(){

            @Override
            public void close() {
                if (cache != null) {
                    cache.close();
                }
                th.set(ExtContext.this.parent);
            }
        };
    }

    public void closeStatements() {
        if (!this.statements.isEmpty()) {
            for (Statement stmt : new ArrayList<Statement>(this.statements)) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            this.statements.clear();
        }
    }

    void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public String getDBRoute() {
        return this.dbRoute;
    }

    public DBType getDBType() {
        return this.dbType;
    }

    ParallelConnectionHolder getConnectionHolder() {
        return this.connectionHolder;
    }

    static {
        ExtInit.init();
    }
}

