/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.hint;

import java.util.ArrayList;
import java.util.Iterator;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;
import kd.bos.xdb.xpm.metrics.feature.SQLFeature;

public final class ExtractHeadCommentAndTrim {
    private static final String hint_no_sharding = "/*XDB:NO_SHARDING*/";
    private static final String hint_dialect = "/*dialect*/";
    private static final String hint_performance_metrics = "/*XDB:PERFORMANCE_METRICS*/";
    private static final String hint_action_metrics = "/*XDB:ACTION_METRICS*/";
    private SQLFeature feature;
    private ShardingHintContext shardingHintContext;
    private String sql;

    public ExtractHeadCommentAndTrim(MetricsCollector mc) {
        this.feature = mc.sqlFeature();
    }

    public void extract(String sql) {
        char[] chs = sql.toCharArray();
        StringBuilder all = new StringBuilder(sql.length());
        ArrayList<String> commentList = new ArrayList<String>();
        boolean sqlBegined = false;
        boolean inDoubleQuote = false;
        boolean inComment = false;
        int n = chs.length;
        StringBuilder seg = new StringBuilder(128);
        block18: for (int i = 0; i < n; ++i) {
            char ch = chs[i];
            if (!sqlBegined) {
                switch (ch) {
                    case '\"': {
                        inDoubleQuote = !inDoubleQuote;
                        break;
                    }
                    case '/': {
                        if (inComment || inDoubleQuote || i + 1 >= n || chs[i + 1] != '*') break;
                        inComment = true;
                        if (seg.length() > 0) {
                            all.append((CharSequence)seg);
                            seg.setLength(0);
                        }
                        seg.append('/').append('*');
                        ++i;
                        continue block18;
                    }
                    case '*': {
                        if (!inComment || inDoubleQuote || i + 1 >= n || chs[i + 1] != '/') break;
                        inComment = false;
                        seg.append('*').append('/');
                        commentList.add(seg.toString());
                        seg.setLength(0);
                        ++i;
                        continue block18;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (sqlBegined || inComment) break;
                        continue block18;
                    }
                    default: {
                        if (inComment) break;
                        sqlBegined = true;
                    }
                }
                seg.append(ch);
                continue;
            }
            seg.append(ch);
        }
        if (seg.length() > 0) {
            all.append((CharSequence)seg);
        }
        this.sql = all.toString().trim();
        while (this.sql.charAt(this.sql.length() - 1) == ';') {
            this.sql = this.sql.substring(0, this.sql.length() - 1).trim();
        }
        if (!commentList.isEmpty()) {
            ArrayList<String> keepComments = new ArrayList<String>();
            Iterator iterator = commentList.iterator();
            block20: while (iterator.hasNext()) {
                String comment;
                switch (comment = (String)iterator.next()) {
                    case "/*dialect*/": {
                        this.feature.setDialect(true);
                        keepComments.add(comment);
                        continue block20;
                    }
                    case "/*XDB:NO_SHARDING*/": {
                        this.feature.setWithNoShardingHint(true);
                        continue block20;
                    }
                    case "/*XDB:PERFORMANCE_METRICS*/": {
                        this.feature.setWithPerformanceMetricHint(true);
                        continue block20;
                    }
                    case "/*XDB:ACTION_METRICS*/": {
                        this.feature.setWithActionMetricHint(true);
                        continue block20;
                    }
                }
                ShardingHintContext ctx = ShardingHintContext.fromShardingHintString(comment);
                if (ctx != null) {
                    this.shardingHintContext = ctx;
                    this.feature.setWithShardingHint(true);
                    continue;
                }
                keepComments.add(comment);
            }
            if (!keepComments.isEmpty()) {
                for (int i = keepComments.size() - 1; i >= 0; --i) {
                    this.sql = (String)keepComments.get(i) + this.sql;
                }
            }
        }
    }

    public String getSql() {
        return this.sql;
    }

    public ShardingHintContext getShardingHintContext() {
        return this.shardingHintContext;
    }
}

