/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.hint;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class HintCondition {
    final String field;
    final FilterType filterType;
    final Object value;

    public HintCondition(String field, String cp, Object value) {
        this.field = field.toLowerCase();
        this.value = value;
        switch (cp.trim().toLowerCase()) {
            case "=": {
                this.filterType = FilterType.eq;
                break;
            }
            case "!=": {
                this.filterType = FilterType.not_eq;
                break;
            }
            case ">": {
                this.filterType = FilterType.gt;
                break;
            }
            case ">=": {
                this.filterType = FilterType.ge;
                break;
            }
            case "<": {
                this.filterType = FilterType.lt;
                break;
            }
            case "<=": {
                this.filterType = FilterType.le;
                break;
            }
            case "between": {
                this.filterType = FilterType.between_and;
                break;
            }
            case "not between": {
                this.filterType = FilterType.not_between_and;
                break;
            }
            case "in": {
                this.filterType = FilterType.in_range;
                break;
            }
            case "not in": {
                this.filterType = FilterType.not_in_range;
                break;
            }
            case "like": {
                this.filterType = FilterType.like;
                break;
            }
            case "not like": {
                this.filterType = FilterType.not_like;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Hint condition not support filter type: " + cp);
            }
        }
    }

    public HintCondition(String field, FilterType filterType, Object value) {
        this.field = field.toLowerCase();
        this.filterType = filterType;
        this.value = value;
    }

    public String getField() {
        return this.field;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return this.field + ' ' + this.filterType.getCP() + ' ' + this.value;
    }

    String toJson() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.field).append(':').append(this.filterType.name()).append(':');
        Class<?> cls = this.value.getClass();
        if (Number.class.isAssignableFrom(cls)) {
            sb.append('n').append(':');
            sb.append(JSON.toJSONString((Object)this.value));
        } else if (Date.class.isAssignableFrom(cls)) {
            sb.append('d').append(':');
            sb.append(((Date)this.value).getTime());
        } else if (cls == String.class) {
            sb.append('s').append(':');
            sb.append(this.value);
        } else {
            sb.append('o').append(':');
            sb.append(JSON.toJSONString((Object)this.value));
        }
        return sb.toString();
    }

    static HintCondition fromJson(String s) {
        Object value;
        int p = s.indexOf(58);
        String field = s.substring(0, p);
        s = s.substring(p + 1);
        p = s.indexOf(58);
        FilterType filterType = FilterType.valueOf(s.substring(0, p));
        s = s.substring(p + 1);
        p = s.indexOf(58);
        String type = s.substring(0, p);
        s = s.substring(p + 1);
        switch (type.charAt(0)) {
            case 'n': {
                value = JSON.parse((String)s);
                break;
            }
            case 'd': {
                value = new Date(Long.parseLong(s));
                break;
            }
            case 's': {
                value = s;
                break;
            }
            default: {
                value = JSON.parse((String)s);
            }
        }
        return new HintCondition(field, filterType, value);
    }
}

