/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.jdbc.statement;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import kd.bos.xdb.AutoCloseSet;
import kd.bos.xdb.ext.KSQL;
import kd.bos.xdb.hint.NoShardingHint;
import kd.bos.xdb.jdbc.statement.AbstractStatement;
import kd.bos.xdb.mergeengine.ErrorClose;
import kd.bos.xdb.xpm.metrics.collector.MetricsCollector;

public class XDBPrepareStatement
extends AbstractStatement {
    static final XDBPrepareStatement statement = new XDBPrepareStatement();

    public static XDBPrepareStatement get() {
        return statement;
    }

    public PreparedStatement prepareStatement(AutoCloseSet autoCloseSet, Connection con, String sql, int queryTimeoutSeconds, MetricsCollector mc) throws SQLException {
        PreparedStatement stmt = this.prepareStatement(con, sql, queryTimeoutSeconds, mc);
        autoCloseSet.add(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(ErrorClose errorClose, Connection con, String sql, int queryTimeoutSeconds, MetricsCollector mc) throws SQLException {
        PreparedStatement stmt = this.prepareStatement(con, sql, queryTimeoutSeconds, mc);
        errorClose.add(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(Connection con, String sql, int queryTimeoutSeconds, MetricsCollector mc) throws SQLException {
        sql = this.markDialectSQL(sql);
        if (mc.isActionMetricEnabled()) {
            mc.collectSQL(sql);
        }
        PreparedStatement stmt = con.prepareStatement(sql, 1003, 1007);
        stmt.setQueryTimeout(queryTimeoutSeconds);
        stmt.setFetchDirection(1000);
        stmt.setFetchSize(config.getQueryFetchSize());
        return stmt;
    }

    private String markDialectSQL(String sql) {
        sql = NoShardingHint.removeNoShardingSQL(sql);
        if (config.isUseKSQL()) {
            return sql;
        }
        return KSQL.dialect(sql);
    }
}

