/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kd.bos.xdb.merge.ProxyResultSet;

public class WrapNextCloseResultSet
extends ProxyResultSet {
    protected final PreparedStatement ps;
    protected ResultSetMetaData md;
    protected boolean nextClosed = false;
    protected boolean realClosed = false;

    public WrapNextCloseResultSet(ResultSet rs, PreparedStatement ps) {
        super(rs);
        this.ps = ps;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.nextClosed) {
            return false;
        }
        if (this.rs.next()) {
            return true;
        }
        if (!this.nextClosed) {
            this.nextClosed = true;
            this.md = this.rs.getMetaData();
            this.closeCurrentResultSet();
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (!this.realClosed) {
            this.realClosed = true;
            if (!this.nextClosed) {
                this.md = this.rs.getMetaData();
                this.closeCurrentResultSet();
            }
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.nextClosed || this.realClosed) {
            return this.md;
        }
        return this.rs.getMetaData();
    }

    protected void closeCurrentResultSet() throws SQLException {
        if (!this.rs.isClosed()) {
            this.rs.close();
            if (!this.ps.isClosed()) {
                this.ps.close();
            }
        }
    }
}

