/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.feature;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bundle.BosRes;

public class GroupByInfo {
    private List<GroupByItem> items = new ArrayList<GroupByItem>();
    private List<SQLSelectItem> selectItems;

    public GroupByInfo(List<SQLSelectItem> selectItems) {
        this(null, selectItems);
    }

    public GroupByInfo(SQLSelectGroupByClause sggc, List<SQLSelectItem> selectItems) {
        if (sggc != null) {
            for (SQLExpr expr : sggc.getItems()) {
                this.items.add(new GroupByItem(expr));
            }
        }
        this.items = Collections.unmodifiableList(this.items);
        this.selectItems = Collections.unmodifiableList(selectItems);
    }

    public void flushGroupByItemIndex(Map<String, Integer> colIndexMap, Map<String, Integer> colExprNameIndexMap) {
        for (GroupByItem item : this.items) {
            String field = item.getField();
            Integer index = colIndexMap.get(field.toLowerCase());
            if (index == null) {
                index = colExprNameIndexMap.get(field.toLowerCase());
            }
            if (index == null) continue;
            item.setIndex(index);
        }
        this.items = Collections.unmodifiableList(this.items);
    }

    public List<GroupByItem> getGroupByItems() {
        return this.items;
    }

    public List<SQLSelectItem> getSelectItems() {
        return this.selectItems;
    }

    public static class GroupByItem {
        private String field;
        private SQLExpr expr;
        private int index;

        public GroupByItem(SQLExpr expr) {
            if (expr instanceof SQLIdentifierExpr) {
                this.field = expr.toString().toLowerCase();
            } else if (expr instanceof SQLPropertyExpr) {
                this.field = expr.toString().toLowerCase();
            } else if (expr instanceof SQLMethodInvokeExpr) {
                this.field = expr.toString().toLowerCase();
            } else {
                throw new UnsupportedOperationException(BosRes.get((String)"bos-xdb", (String)"GroupByInfo_0", (String)"group by\u4e0d\u652f\u6301\u8868\u8fbe\u5f0f:{0}\u3002", (Object[])new Object[]{expr}));
            }
            this.expr = expr;
        }

        public String getField() {
            return this.field;
        }

        public SQLExpr getExpr() {
            return this.expr;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String toString() {
            return this.expr.toString();
        }
    }
}

