/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.feature;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OrderByInfo {
    private List<OrderByItem> items = new ArrayList<OrderByItem>(16);
    private List<SQLSelectItem> selectItems;
    private boolean resetSelect = false;
    private int originalSelectColumnCount;

    public OrderByInfo(List<SQLSelectOrderByItem> items, List<SQLSelectItem> selectItems) {
        for (SQLSelectOrderByItem item : items) {
            String field = item.getExpr().toString();
            boolean asc = item.getType() != SQLOrderingSpecification.DESC;
            this.items.add(new OrderByItem(item.getExpr(), field, asc));
        }
        this.items = Collections.unmodifiableList(this.items);
        this.selectItems = Collections.unmodifiableList(selectItems);
        this.originalSelectColumnCount = selectItems.size();
    }

    public void flushOrderByItemIndex(Map<String, Integer> colIndexMap, Map<String, Integer> colExprNameIndexMap) {
        for (OrderByItem item : this.items) {
            String field = item.getField();
            Integer index = colIndexMap.get(field.toLowerCase());
            if (index == null) {
                index = colExprNameIndexMap.get(field.toLowerCase());
            }
            if (index == null) continue;
            item.setIndex(index);
        }
        this.items = Collections.unmodifiableList(this.items);
    }

    public List<OrderByItem> getOrderByItems() {
        return this.items;
    }

    public List<SQLSelectItem> getSelectItems() {
        return this.selectItems;
    }

    public void resetSelectItemsAddOrderBy(List<SQLSelectItem> selectItems) {
        this.selectItems = Collections.unmodifiableList(selectItems);
        this.resetSelect = true;
    }

    public boolean isResetSelect() {
        return this.resetSelect;
    }

    public int getOriginalSelectColumnCount() {
        return this.originalSelectColumnCount;
    }

    public String toString() {
        return this.items.toString();
    }

    public static class OrderByItem {
        private String field;
        private SQLExpr expr;
        private boolean asc;
        private int index;

        public OrderByItem(SQLExpr expr, String field, boolean asc) {
            this.expr = expr;
            this.field = field.toLowerCase();
            this.asc = asc;
        }

        public SQLExpr getExpr() {
            return this.expr;
        }

        public String getField() {
            return this.field;
        }

        public boolean isAsc() {
            return this.asc;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String toString() {
            return this.field + (this.asc ? " asc" : " desc");
        }
    }
}

