/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.groupby;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bundle.Resources;
import kd.bos.xdb.merge.MergeManager;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.groupby.AggregateFunction;
import kd.bos.xdb.merge.groupby.AggregateFunctionFactory;
import kd.bos.xdb.merge.groupby.AggregateTypeClass;
import kd.bos.xdb.merge.resultset.memory.Row;

public final class Aggregator {
    private final int cols;
    private final int gbLen;
    private final int[] groupByItemIndexies;
    private final Set<Integer> groupByItemIndexiesSet = new HashSet<Integer>(16);
    private final List<SQLSelectItem> selectItems;
    private final Class<?>[] columnCls;
    private AggregateFunction[] afs;

    public Aggregator(GroupByInfo gbi, Map<String, Integer> colIndexMap, ResultSetMetaData metaData) throws SQLException {
        int i;
        this.cols = colIndexMap.size();
        this.selectItems = gbi.getSelectItems();
        List<GroupByInfo.GroupByItem> groupByItems = gbi.getGroupByItems();
        this.gbLen = groupByItems.size();
        this.groupByItemIndexies = new int[this.gbLen];
        for (i = 0; i < this.groupByItemIndexies.length; ++i) {
            String groupByName = groupByItems.get(i).getField();
            Integer index = colIndexMap.get(groupByName);
            if (index == null) {
                index = MergeManager.findSelectItemIndexByName(gbi.getSelectItems(), groupByName);
            }
            if (index == null) {
                throw new IllegalArgumentException(Resources.get((String)"bos-xdb", (String)"Aggregator_0", (String)"\u5408\u5e76\u5206\u7247,group by\u7684\u8868\u8fbe\u5f0f\u5fc5\u987b\u51fa\u73b0\u5728select\u4e2d:{0}\u3002", (Object[])new Object[]{groupByName}));
            }
            this.groupByItemIndexies[i] = index;
            this.groupByItemIndexiesSet.add(index);
        }
        this.columnCls = new Class[this.cols];
        for (i = 1; i <= this.cols; ++i) {
            int type = metaData.getColumnType(i);
            this.columnCls[i - 1] = AggregateTypeClass.getClass(type);
        }
    }

    public List<Row> agg(List<Row> data) {
        if (data.isEmpty()) {
            return new ArrayList<Row>();
        }
        LinkedList<List<Row>> gbRowList = new LinkedList<List<Row>>();
        if (this.gbLen == 0) {
            gbRowList.add(data);
        } else {
            HashMap gbhashMap = new HashMap(16);
            HashMap gbMap = new HashMap(16);
            block0: for (Row row : data) {
                Object[] groupByKeys = new Object[this.gbLen];
                for (int i = 0; i < this.gbLen; ++i) {
                    groupByKeys[i] = row.get(this.groupByItemIndexies[i]);
                }
                int h = Arrays.toString(groupByKeys).hashCode();
                ArrayList<Object[]> sameHashCodeKeys = (ArrayList<Object[]>)gbhashMap.get(h);
                if (sameHashCodeKeys == null) {
                    sameHashCodeKeys = new ArrayList<Object[]>(1);
                    sameHashCodeKeys.add(groupByKeys);
                    gbhashMap.put(h, sameHashCodeKeys);
                    ArrayList<Row> gbRows = new ArrayList<Row>(16);
                    gbRows.add(row);
                    gbMap.put(groupByKeys, gbRows);
                    gbRowList.add(gbRows);
                    continue;
                }
                for (Object[] existKeys : sameHashCodeKeys) {
                    if (!this.equals(existKeys, groupByKeys)) continue;
                    List gbRows = (List)gbMap.get(existKeys);
                    gbRows.add(row);
                    continue block0;
                }
            }
            if (data.size() == gbRowList.size()) {
                return data;
            }
            gbhashMap = null;
            gbMap = null;
        }
        this.createColumnMergeFunction();
        LinkedList<Row> ret = new LinkedList<Row>();
        for (List list : gbRowList) {
            ret.add(this.merge(list));
        }
        return ret;
    }

    private boolean equals(Object[] a1, Object[] a2) {
        for (int i = 0; i < this.gbLen; ++i) {
            if (Objects.equals(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    private void createColumnMergeFunction() {
        this.afs = new AggregateFunction[this.cols];
        for (int i = 0; i < this.cols; ++i) {
            if (this.groupByItemIndexiesSet.contains(i)) continue;
            SQLExpr expr = this.selectItems.get(i).getExpr();
            if (!(expr instanceof SQLAggregateExpr)) {
                throw new IllegalArgumentException(Resources.get((String)"bos-xdb", (String)"Aggregator_1", (String)"\u8868\u8fbe\u5f0f\u52a1\u5fc5\u4e3a\u805a\u5408\u51fd\u6570:{0}\u3002", (Object[])new Object[]{expr}));
            }
            SQLAggregateExpr aggExpr = (SQLAggregateExpr)expr;
            this.afs[i] = AggregateFunctionFactory.getAggregateFunction(aggExpr.getMethodName());
        }
    }

    private Row merge(List<Row> rows) {
        Row ret = new Row(this.cols);
        Row row = rows.get(0);
        for (int j = 0; j < this.cols; ++j) {
            ret.set(j, row.get(j));
        }
        int n = rows.size();
        for (int i = 1; i < n; ++i) {
            row = rows.get(i);
            for (int j = 0; j < this.cols; ++j) {
                if (this.groupByItemIndexiesSet.contains(j)) continue;
                ret.set(j, this.afs[j].agg(ret.get(j), row.get(j), this.columnCls[j]));
            }
        }
        ret.finishSet();
        return ret;
    }
}

