/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.groupby;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.xdb.merge.AbstractMerger;
import kd.bos.xdb.merge.feature.GroupByInfo;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.merge.groupby.GroupByDataSetMergeSet;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.StreamMergeSet;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.sharding.config.ShardingConfigProvider;
import kd.bos.xdb.sharding.sql.parser.StatementInfo;
import kd.bos.xdb.sharding.sql.parser.TableInfo;
import kd.bos.xdb.xpm.metrics.action.merge.MergeFeatureSpan;

public final class GroupByMerger
extends AbstractMerger<StreamMergeSet> {
    private final StatementInfo si;
    private final ShardingConfigProvider scp;
    private final boolean checkGroupByEffectiveShardingKey;

    public GroupByMerger(StreamMergeSet ms, SelectFeature sf) {
        this(ms, sf, null, null);
    }

    public GroupByMerger(StreamMergeSet ms, SelectFeature sf, StatementInfo si, ShardingConfigProvider scp) {
        super(ms, sf);
        this.si = si;
        this.scp = scp;
        this.checkGroupByEffectiveShardingKey = si != null;
    }

    @Override
    public MergeSet merge(MergeFeatureSpan mspan) {
        if (this.checkGroupByEffectiveShardingKey && this.groupByEffectiveShardingKey()) {
            mspan.setGroupByUseShardingResultDirectly();
            return this.ms;
        }
        mspan.addMergePath(GroupByDataSetMergeSet.class.getSimpleName());
        return new GroupByDataSetMergeSet(this.ms, this.sf.getGroupByInfo());
    }

    private boolean groupByEffectiveShardingKey() {
        HashMap<SQLExprTableSource, Set> effectiveGroupFields = new HashMap<SQLExprTableSource, Set>();
        List<GroupByInfo.GroupByItem> groupItems = this.sf.getGroupByInfo().getGroupByItems();
        boolean hasEffectiveGroupField = false;
        for (GroupByInfo.GroupByItem item : groupItems) {
            Set columnSet;
            SQLExprTableSource ts;
            SQLExpr expr = item.getExpr();
            if (expr instanceof SQLIdentifierExpr) {
                SQLIdentifierExpr id = (SQLIdentifierExpr)expr;
                ts = (SQLExprTableSource)id.getResolvedOwnerObject();
                columnSet = effectiveGroupFields.computeIfAbsent(ts, ts2 -> new HashSet());
                columnSet.add(id.toString().toLowerCase());
                if (hasEffectiveGroupField) continue;
                hasEffectiveGroupField = true;
                continue;
            }
            if (!(expr instanceof SQLPropertyExpr)) continue;
            SQLPropertyExpr p = (SQLPropertyExpr)expr;
            ts = (SQLExprTableSource)p.getResolvedOwnerObject();
            columnSet = effectiveGroupFields.computeIfAbsent(ts, ts2 -> new HashSet(16));
            columnSet.add(p.getName().toLowerCase());
            if (hasEffectiveGroupField) continue;
            hasEffectiveGroupField = true;
        }
        if (!hasEffectiveGroupField) {
            return false;
        }
        for (TableInfo ti : this.si.getTableInfos()) {
            ShardingConfig config = this.scp.getConfig(ti.getName());
            if (config == null) continue;
            Set effectiveGroupFieldSet = (Set)effectiveGroupFields.get(ti.getSQLTableSource());
            if (effectiveGroupFieldSet == null) {
                return false;
            }
            for (String shardingField : config.getShardingFields()) {
                if (effectiveGroupFieldSet.contains(shardingField)) continue;
                return false;
            }
        }
        return true;
    }
}

