/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.limit;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kd.bos.xdb.merge.resultset.MergeSet;

public final class LimitMergeSet
implements MergeSet {
    private final int offset;
    private final int len;
    private boolean skipped = false;
    private int curIndex = 0;
    private MergeSet ms;

    public LimitMergeSet(int offset, int len, MergeSet ms) {
        this.offset = offset;
        this.len = len;
        this.ms = ms;
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.skipped) {
            this.skipped = true;
            int i = 0;
            while (i++ < this.offset) {
                if (this.ms.next()) continue;
                return false;
            }
        }
        if (this.curIndex++ >= this.len) {
            return false;
        }
        return this.ms.next();
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return this.ms.get(columnIndex, type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        return this.ms.get(columnName, type);
    }

    @Override
    public void close() throws SQLException {
        if (this.ms != null) {
            this.ms.close();
            this.ms = null;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.ms.getMetaData();
    }
}

