/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.orderby.greedystream;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import kd.bos.xdb.merge.orderby.greedystream.AbstractOrderByStream;
import kd.bos.xdb.merge.orderby.greedystream.SingleStream;
import kd.bos.xdb.merge.resultset.memory.Row;
import kd.bos.xdb.util.RingList;

final class MultiStream
extends AbstractOrderByStream {
    private final List<SingleStream> sortedSS;
    private final Comparator<Row> comparator;
    private final int batchSize;
    private RingList<Row> sortedRowList;
    private boolean closed = false;

    MultiStream(List<SingleStream> sortedSS, Comparator<Row> comparator, int batchSize) {
        this.sortedSS = sortedSS;
        this.comparator = comparator;
        this.batchSize = batchSize;
        this.sortedRowList = new RingList(batchSize);
    }

    @Override
    boolean next() throws SQLException {
        int n;
        if (!this.sortedRowList.isEmpty()) {
            this.curRow = this.sortedRowList.removeFirst();
            return true;
        }
        boolean hasEnd = false;
        for (SingleStream ss : this.sortedSS) {
            ss.fetch(this.batchSize);
            if (!ss.endOfStream() || hasEnd) continue;
            hasEnd = true;
        }
        if (hasEnd) {
            for (SingleStream ss : this.sortedSS.toArray(new SingleStream[this.sortedSS.size()])) {
                if (!ss.endOfStream()) continue;
                this.sortedSS.remove(ss);
            }
        }
        if ((n = this.sortedSS.size()) > 1) {
            if (!this.orderByBlock(n)) {
                this.orderByMerge(n);
            }
            this.curRow = this.sortedRowList.removeFirst();
            return true;
        }
        if (n == 1 && this.sortedSS.get(0).next()) {
            this.curRow = this.sortedSS.get((int)0).curRow;
            return true;
        }
        this.close();
        return false;
    }

    private boolean orderByBlock(int n) {
        for (int i = 1; i < n; ++i) {
            Row r2;
            Row r1 = this.sortedSS.get(i - 1).peekRows().getLast();
            if (this.comparator.compare(r1, r2 = this.sortedSS.get(i).peekRows().getFirst()) < 0) continue;
            return false;
        }
        RingList<Row> peekRows = this.sortedSS.get(0).peekRows();
        this.sortedRowList.copyDataAndClear(peekRows);
        return true;
    }

    private void orderByMerge(int n) {
        Row compareRow = null;
        Row[] data = new Row[n];
        RingList[] prs = new RingList[n];
        int i = 0;
        for (SingleStream ss : this.sortedSS) {
            prs[i] = ss.peekRows();
            compareRow = (Row)prs[i].peekFirst();
            compareRow.setTag(i);
            data[i++] = compareRow;
        }
        Arrays.sort(data, this.comparator);
        int compareRowDataIndex = 0;
        int ssIndex = this.pick(data, compareRowDataIndex, prs);
        block1: for (int j = 1; j < this.batchSize; ++j) {
            compareRow = (Row)prs[ssIndex].peekFirst();
            if (compareRow == null) {
                if (++compareRowDataIndex == n) break;
                ssIndex = this.pick(data, compareRowDataIndex, prs);
                continue;
            }
            if (compareRowDataIndex == n - 1) {
                this.sortedRowList.add(compareRow);
                prs[ssIndex].removeFirst();
                continue;
            }
            if (this.comparator.compare(compareRow, data[compareRowDataIndex + 1]) <= 0) {
                this.sortedRowList.add(compareRow);
                prs[ssIndex].removeFirst();
                continue;
            }
            compareRow.setTag(ssIndex);
            ssIndex = this.pick(data, compareRowDataIndex + 1, prs);
            int compareFrom = compareRowDataIndex + 1 + 1;
            if (compareFrom == n) {
                data[compareRowDataIndex + 1] = compareRow;
                continue;
            }
            int low = compareFrom;
            int high = n - 1;
            while (true) {
                int mid;
                int cp;
                if ((cp = this.comparator.compare(compareRow, data[mid = (high + low) / 2])) < 0) {
                    if (mid == low) {
                        this.insertBefore(data, compareRow, mid, compareRowDataIndex);
                        continue block1;
                    }
                    high = mid - 1;
                    continue;
                }
                if (cp == 0) {
                    this.insertBefore(data, compareRow, mid, compareRowDataIndex);
                    continue block1;
                }
                if (mid == high) {
                    this.insertBefore(data, compareRow, mid + 1, compareRowDataIndex);
                    continue block1;
                }
                low = mid + 1;
            }
        }
    }

    private void insertBefore(Row[] data, Row compareRow, int index, int compareRowDataIndex) {
        int len = index - 1 - compareRowDataIndex;
        if (len == 1) {
            data[compareRowDataIndex + 1] = data[compareRowDataIndex];
        } else {
            System.arraycopy(data, compareRowDataIndex + 1, data, compareRowDataIndex, len);
        }
        data[index - 1] = compareRow;
    }

    private int pick(Row[] data, int pickDataFromIndex, RingList<Row>[] prs) {
        int ssIndex = data[pickDataFromIndex].getTag();
        this.sortedRowList.add(data[pickDataFromIndex]);
        data[pickDataFromIndex] = null;
        prs[ssIndex].removeFirst();
        return ssIndex;
    }

    @Override
    void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.curRow = null;
        }
    }
}

