/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.resultset;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.ObjectConverter;

public final class StreamMergeSet
implements MergeSet {
    private ResultSet[] rss;
    private int i = 1;
    private ResultSet rs;

    public StreamMergeSet(ResultSet ... rss) {
        this.rss = rss;
        this.rs = rss[0];
    }

    @Override
    public boolean next() throws SQLException {
        if (this.rs.next()) {
            return true;
        }
        while (this.nextResultSet()) {
            if (!this.rs.next()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
            for (int j = this.i; j < this.rss.length; ++j) {
                if (this.rss[j] == null) continue;
                this.rss[j].close();
                this.rss[j] = null;
            }
            this.rs = null;
            this.rss = null;
        }
    }

    private boolean nextResultSet() {
        if (this.i < this.rss.length) {
            this.rs = this.rss[this.i++];
            return true;
        }
        return false;
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.rs.getObject(columnIndex + 1), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.rs.getObject(columnName), type);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.rss[0].getMetaData();
    }

    public ResultSet[] getOriginalResultSets() {
        return this.rss;
    }
}

