/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.union;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.xdb.engine.UnionType;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.ObjectConverter;
import kd.bos.xdb.merge.resultset.memory.Row;

public final class MixUnionMergeSet
implements MergeSet {
    private Map<String, Integer> colIndexMap = new HashMap<String, Integer>(16);
    private Row curRow;
    private Map<Integer, List<Row>> loadedMap = new HashMap<Integer, List<Row>>(16);
    private final int cols;
    private final List<UnionType> unionTypes;
    private final List<ResultSet> rss;
    private ResultSet firstRS;
    private final int rssSize;
    private ResultSet curRS;
    private int curRSIndex = 0;
    private UnionType curUnionType = UnionType.unoin_all;

    public MixUnionMergeSet(List<UnionType> unionTypes, List<ResultSet> rss) throws SQLException {
        this.unionTypes = unionTypes;
        this.rss = rss;
        this.rssSize = rss.size();
        this.firstRS = rss.get(0);
        ResultSetMetaData md = this.firstRS.getMetaData();
        this.cols = md.getColumnCount();
        for (int i = 0; i < this.cols; ++i) {
            this.colIndexMap.put(md.getColumnName(i + 1).toLowerCase(), i);
        }
        this.curRS = this.firstRS;
    }

    private boolean moveNext() throws SQLException {
        if (!this.curRS.next()) {
            if (this.curRSIndex == this.rssSize - 1) {
                return false;
            }
            ++this.curRSIndex;
            this.curRS = this.rss.get(this.curRSIndex);
            this.curUnionType = this.unionTypes.get(this.curRSIndex - 1);
            return this.moveNext();
        }
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        while (this.moveNext()) {
            Row row = this.nextRow();
            int h = row.hashCode();
            List<Row> list = this.loadedMap.get(h);
            if (list == null) {
                list = new ArrayList<Row>(1);
                this.loadedMap.put(h, list);
                list.add(row);
                this.curRow = row;
                return true;
            }
            boolean exists = false;
            if (this.curUnionType == UnionType.unoin) {
                for (Row loaded : list) {
                    if (!row.equals(loaded)) continue;
                    exists = true;
                    break;
                }
            }
            if (exists) continue;
            list.add(row);
            this.curRow = row;
            return true;
        }
        return false;
    }

    private Row nextRow() throws SQLException {
        Row row = new Row(this.cols);
        for (int i = 0; i < this.cols; ++i) {
            row.set(i, this.curRS.getObject(i + 1));
        }
        row.finishSet();
        return row;
    }

    @Override
    public <T> T get(int columnIndex, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.curRow.get(columnIndex), type);
    }

    @Override
    public <T> T get(String columnName, Class<T> type) throws SQLException {
        return ObjectConverter.convert(this.curRow.get(this.colIndexMap.get(columnName.toLowerCase())), type);
    }

    @Override
    public void close() throws SQLException {
        if (this.curRS != null) {
            for (ResultSet rs : this.rss) {
                rs.close();
            }
            this.curRS = null;
            this.curRow = null;
            this.firstRS = null;
            this.loadedMap = null;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.firstRS.getMetaData();
    }
}

