/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.merge.union;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import kd.bos.xdb.engine.ShardingResult;
import kd.bos.xdb.engine.UnionType;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.merge.MergeCallback;
import kd.bos.xdb.merge.Merger;
import kd.bos.xdb.merge.distinct.DistinctDataSetMergeSet;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.StreamMergeSet;
import kd.bos.xdb.util.Pair;
import kd.bos.xdb.xpm.metrics.action.merge.MergeFeatureSpan;

public class UnionMerger
implements Merger {
    private final List<Pair<ShardingResult, ResultSet>> rss;
    private final MergeCallback<ResultSet, Pair<ShardingResult, ResultSet>> rsCallback;

    public UnionMerger(List<Pair<ShardingResult, ResultSet>> rss, MergeCallback<ResultSet, Pair<ShardingResult, ResultSet>> rsCallback) {
        this.rsCallback = rsCallback;
        this.rss = rss;
    }

    @Override
    public MergeSet merge(MergeFeatureSpan mspan) {
        try {
            int size = this.rss.size();
            ResultSet[] rsArray = new ResultSet[size];
            for (int i = 0; i < size; ++i) {
                rsArray[i] = this.rsCallback.callback(this.rss.get(i));
            }
            boolean allUnionAll = true;
            for (Pair<ShardingResult, ResultSet> p : this.rss) {
                UnionType type = p.getKey().getUnionType();
                if (type != UnionType.unoin) continue;
                allUnionAll = false;
                break;
            }
            if (allUnionAll) {
                mspan.addMergePath(StreamMergeSet.class.getSimpleName());
                return new StreamMergeSet(rsArray);
            }
            mspan.addMergePath(StreamMergeSet.class.getSimpleName());
            mspan.addMergePath(DistinctDataSetMergeSet.class.getSimpleName());
            return new DistinctDataSetMergeSet(new StreamMergeSet(rsArray));
        }
        catch (SQLException e) {
            throw ExceptionUtil.wrap(e);
        }
    }
}

