/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.xdb.mergeengine;

import java.sql.ResultSet;
import java.sql.SQLException;
import kd.bos.xdb.AutoCloseSet;
import kd.bos.xdb.merge.WrapCloseResultSet;
import kd.bos.xdb.merge.feature.SelectFeature;
import kd.bos.xdb.merge.limit.LimitMerger;
import kd.bos.xdb.merge.resultset.MergeSet;
import kd.bos.xdb.merge.resultset.MergedResultSet;
import kd.bos.xdb.mergeengine.ExecutionContext;
import kd.bos.xdb.mergeengine.MergeEngine;
import kd.bos.xdb.xpm.metrics.action.merge.MergeFeatureSpan;

public abstract class AbstractMergeEngine
implements MergeEngine {
    @Override
    public ResultSet merge(ExecutionContext executionContext) throws SQLException {
        AutoCloseSet autoCloseSet = new AutoCloseSet();
        return this.wrapCloseResultSet(this.doMerge(executionContext), () -> this.close(autoCloseSet, false));
    }

    protected ResultSet wrapCloseResultSet(MergeSet ms, AutoCloseable onClose) throws SQLException {
        MergedResultSet rs = new MergedResultSet(ms, ms.getMetaData());
        return new WrapCloseResultSet(rs, onClose);
    }

    protected void close(AutoCloseSet autoCloseSet, boolean rollback) throws SQLException {
        autoCloseSet.close(rollback);
    }

    protected MergeSet topDecorate(SelectFeature sf, MergeSet ms, MergeFeatureSpan mspan) {
        if (sf != null && sf.hasLimit()) {
            return new LimitMerger(ms, sf).merge(mspan);
        }
        return ms;
    }
}

